/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import java.io.Serializable;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;

public class CheckReport
implements Serializable {
    private static final long serialVersionUID = 5067012929427392490L;
    private LinkedList<ReportEntry> reportEntries = new LinkedList();
    private ResultType checkResult = ResultType.OK;
    private URI base = null;
    private int nextEntryNumber = 0;

    public CheckReport(URI base) {
        this.base = base;
    }

    public URI getBase() {
        return this.base;
    }

    public void addReportEntry(String checkID, ResultType reportEntryType, String message, URI ... affectedElements) {
        ReportEntry reportEntry = new ReportEntry(this.nextEntryNumber, checkID, reportEntryType, message, affectedElements);
        this.reportEntries.add(reportEntry);
        ++this.nextEntryNumber;
        this.updateCheckResult(reportEntryType);
    }

    private void updateCheckResult(ResultType reportEntryType) {
        if (reportEntryType.ordinal() > this.checkResult.ordinal()) {
            this.checkResult = reportEntryType;
        }
    }

    public List<ReportEntry> getReportEntries() {
        return this.reportEntries;
    }

    public String getReportSummary() {
        StringBuilder sum = new StringBuilder();
        boolean first = true;
        for (ReportEntry entry : this.getReportEntries()) {
            if (first) {
                first = false;
            } else {
                sum.append("\n");
            }
            sum.append(String.format("%s: %s\n%s: %s\n", new Object[]{entry.getEntryNumber(), entry.getCheckID(), entry.getReportEntryType(), entry.getMessage()}));
            URI[] affectedElements = entry.getAffectedADEPT2ProcessElements();
            if (affectedElements.length <= 0) continue;
            sum.append("Affected Elements:\n");
            URI[] uRIArray = affectedElements;
            int n = affectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                URI affectedADEPT2ProcessElements = uRIArray[n2];
                sum.append(String.format("    %s\n", affectedADEPT2ProcessElements));
                ++n2;
            }
        }
        sum.append("\n");
        return sum.toString();
    }

    public String getAREReportSummary() {
        StringBuilder sum = new StringBuilder();
        for (ReportEntry entry : this.getReportEntries()) {
            sum.append(String.format("%s. %s: %s\n", new Object[]{entry.getEntryNumber() + 1, entry.getReportEntryType(), entry.getMessage()}));
        }
        sum.append("\n");
        return sum.toString();
    }

    public String getSimpleReportSummary() {
        StringBuilder sum = new StringBuilder();
        sum.append("\n");
        for (ReportEntry entry : this.getReportEntries()) {
            if (!entry.getReportEntryType().equals((Object)ResultType.WARNING) && !entry.getReportEntryType().equals((Object)ResultType.FAILURE)) continue;
            sum.append(String.format("\n%s: %s\n%s: %s\nAffected Elements: ", new Object[]{Integer.toString(entry.getEntryNumber()), entry.getCheckID(), entry.getReportEntryType(), entry.getMessage()}));
            URI[] uRIArray = entry.getAffectedADEPT2ProcessElements();
            int n = uRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI affectedADEPT2ProcessElements = uRIArray[n2];
                sum.append(String.format("    %s\n", affectedADEPT2ProcessElements));
                ++n2;
            }
        }
        sum.append("\n");
        return sum.toString();
    }

    public void printReportSummary() {
        if (this.reportEntries.size() > 0) {
            System.out.println(this.getReportSummary());
        } else {
            System.out.println("No problems, no report summary!");
        }
    }

    public List<ReportEntry> getEntriesForCheckID(String checkID) {
        LinkedList<ReportEntry> entries = new LinkedList<ReportEntry>();
        for (ReportEntry entry : this.reportEntries) {
            if (!entry.getCheckID().equals(checkID)) continue;
            entries.add(entry);
        }
        return entries;
    }

    public ReportEntry getLastAddedReportEntry() {
        if (this.reportEntries.size() > 0) {
            return this.reportEntries.get(this.nextEntryNumber - 1);
        }
        return null;
    }

    public ResultType getCheckResult() {
        return this.checkResult;
    }

    public static class ReportEntry
    implements Serializable {
        private static final long serialVersionUID = -8741176528702050808L;
        private int entryNumber;
        private String checkID;
        private ResultType reportEntryType;
        private String message;
        private URI[] affectedADEPT2ProcessElements = new URI[0];

        protected ReportEntry(int entryNumber, String checkID, ResultType reportEntryType, String message, URI ... affectedElements) {
            this.entryNumber = entryNumber;
            this.checkID = checkID;
            this.reportEntryType = reportEntryType;
            this.message = message;
            this.affectedADEPT2ProcessElements = affectedElements;
        }

        public String getCheckID() {
            return this.checkID;
        }

        public String getMessage() {
            return this.message;
        }

        public ResultType getReportEntryType() {
            return this.reportEntryType;
        }

        public int getEntryNumber() {
            return this.entryNumber;
        }

        public URI[] getAffectedADEPT2ProcessElements() {
            URI[] ret = null;
            if (this.affectedADEPT2ProcessElements != null) {
                ret = (URI[])this.affectedADEPT2ProcessElements.clone();
            }
            return ret;
        }
    }

    public static enum ResultType {
        OK,
        INFO,
        WARNING,
        FAILURE;

    }
}

