/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class ExecutorTools {
    public static void awaitTermination(ExecutorService executorService) {
        ExecutorTools.awaitTermination(executorService, 0L);
    }

    public static void awaitTermination(ExecutorService executorService, long interruptAfter) {
        if (executorService == null) {
            return;
        }
        boolean terminated = false;
        if (interruptAfter > 0L) {
            try {
                terminated = executorService.awaitTermination(interruptAfter, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (!terminated) {
                executorService.shutdownNow();
            }
        }
        while (!terminated) {
            try {
                terminated = executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ScheduledExecutorService createScheduledExecutor(int minPoolSize, ThreadFactory factory) {
        ScheduledThreadPoolExecutor ret = new ScheduledThreadPoolExecutor(minPoolSize, factory);
        ret.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ret.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        return ret;
    }

    private ExecutorTools() {
    }
}

