/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public final class FileTools {
    public static String getExtension(File file) {
        return FileTools.getExtension(file.getName());
    }

    public static String getExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > -1) {
            return filename.substring(dotIndex + 1);
        }
        return "";
    }

    public static boolean hasExtension(File file, String extension) {
        String ext = FileTools.getExtension(file);
        return ext.equalsIgnoreCase(extension);
    }

    public static File getWithoutExtension(File file) {
        return new File(FileTools.getWithoutExtension(file.getPath()));
    }

    public static String getWithoutExtension(String path) {
        File file = new File(path);
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > -1) {
            fileName = fileName.substring(0, dotIndex);
            if (file.getParent() != null) {
                return String.valueOf(file.getParent()) + File.separator + fileName;
            }
            return fileName;
        }
        return path;
    }

    public static String relativize(String base, String file) {
        return FileTools.relativize(new File(base), new File(file));
    }

    public static String relativize(File base, File file) {
        String filePath;
        String basePath;
        ArgChecks.checkForNull(base, "base");
        ArgChecks.checkForNull(file, "file");
        if (base.exists() && !base.isDirectory()) {
            throw new IllegalArgumentException("The parameter 'base' must denote a directory!");
        }
        try {
            basePath = base.getCanonicalPath();
        }
        catch (IOException iOException) {
            basePath = base.getAbsolutePath();
        }
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            filePath = file.getAbsolutePath();
        }
        String[] baseSegments = basePath.split(Pattern.quote(File.separator));
        String[] fileSegments = filePath.split(Pattern.quote(File.separator));
        StringBuilder relativePath = new StringBuilder();
        if (!new File(baseSegments[0]).equals(new File(fileSegments[0])) && baseSegments[0].charAt(1) == ':') {
            return null;
        }
        boolean first = true;
        int i = 0;
        while (i < baseSegments.length && i < fileSegments.length) {
            if (!new File(baseSegments[i]).equals(new File(fileSegments[i]))) {
                int j = i;
                while (j < baseSegments.length) {
                    if (!baseSegments[j].equals("..")) {
                        if (first) {
                            first = false;
                        } else {
                            relativePath.append(File.separator);
                        }
                        relativePath.append("..");
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        while (i < fileSegments.length) {
            if (first) {
                first = false;
            } else {
                relativePath.append(File.separator);
            }
            relativePath.append(fileSegments[i]);
            ++i;
        }
        return relativePath.toString();
    }

    public static <C extends Closeable> C close(C closeable) throws IOException {
        closeable.close();
        return null;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] toByteArray(File file) throws IOException {
        byte[] byArray;
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file is too large to be copied to a byte array");
        }
        int bytesTotal = (int)file.length();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] bytes = new byte[bytesTotal];
            int bytesReadTotal = 0;
            while (bytesReadTotal < bytesTotal) {
                int bytesRead = fis.read(bytes, bytesReadTotal, bytesTotal - bytesReadTotal);
                bytesReadTotal += bytesRead;
            }
            fis = FileTools.close(fis);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            FileTools.closeQuietly(fis);
            throw throwable;
        }
        FileTools.closeQuietly(fis);
        return byArray;
    }

    private FileTools() {
    }
}

