/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.Arrays;

public class HashCalc {
    private int hashCode;

    public HashCalc(Class<?> forClass) {
        ArgChecks.checkForNull(forClass, "forClass");
        this.hashCode = forClass.getName().hashCode();
    }

    public HashCalc feed(boolean value) {
        return this.feed(Boolean.valueOf(value).hashCode());
    }

    public HashCalc feed(char value) {
        return this.feed((int)value);
    }

    public HashCalc feed(byte value) {
        return this.feed((int)value);
    }

    public HashCalc feed(short value) {
        return this.feed((int)value);
    }

    public HashCalc feed(int value) {
        this.hashCode = 31 * this.hashCode + value;
        return this;
    }

    public HashCalc feed(long value) {
        return this.feed((int)(value ^ value >>> 32));
    }

    public HashCalc feed(float value) {
        return this.feed(Float.floatToRawIntBits(value));
    }

    public HashCalc feed(double value) {
        return this.feed(Double.doubleToRawLongBits(value));
    }

    public HashCalc feed(Object object) {
        return this.feed(object == null ? 0 : object.hashCode());
    }

    public HashCalc feed(boolean[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(byte[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(short[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(int[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(long[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(float[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(double[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public HashCalc feed(Object[] array) {
        return this.feed(Arrays.deepHashCode(array));
    }

    public HashCalc feedShallow(Object[] array) {
        return this.feed(Arrays.hashCode(array));
    }

    public int hashCode() {
        return this.hashCode;
    }
}

