/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.NullArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion
implements Comparable<JavaVersion> {
    private static final Pattern pattern = Pattern.compile("(\\d)\\.(\\d)(?:\\.(\\d)(_\\d\\d?)?(-\\w+)?)?");
    private String versionString;
    private static final JavaVersion current = new JavaVersion();

    private JavaVersion() {
        this(System.getProperty("java.version"));
    }

    public JavaVersion(String versionString) {
        if (versionString == null) {
            throw new NullArgumentException("The parameter 'version' must not be null!");
        }
        Matcher matcher = pattern.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The version string '" + versionString + "' doesn't have a legal format!");
        }
        this.versionString = versionString;
        if (matcher.group(3) == null) {
            this.versionString = String.valueOf(this.versionString) + ".0";
        }
    }

    public boolean isFCS() {
        return !this.versionString.contains("-");
    }

    public boolean satisfiesVersion(String versionString) {
        if (versionString == null) {
            throw new NullArgumentException("The parameter 'versionString' must not be null!");
        }
        if (versionString.trim().equals("")) {
            throw new IllegalArgumentException("The parameter 'versionString' must not be empty or only contain whitespace!");
        }
        new JavaVersion(versionString);
        return this.versionString.startsWith(versionString);
    }

    public boolean satisfiesRange(String lowerLimitVersionString, String upperLimitVersionString) {
        JavaVersion lowerLimit = new JavaVersion(lowerLimitVersionString);
        JavaVersion upperLimit = new JavaVersion(upperLimitVersionString);
        if (lowerLimit.compareTo(upperLimit) > 0) {
            throw new IllegalArgumentException("Lower limit must not be greater than upper limit!");
        }
        return this.compareTo(lowerLimit) >= 0 && this.compareTo(upperLimit) <= 0;
    }

    public boolean satisfiesMinimum(String minimumVersionString) {
        JavaVersion lowerLimit = new JavaVersion(minimumVersionString);
        return this.compareTo(lowerLimit) >= 0;
    }

    @Override
    public int compareTo(JavaVersion otherVersion) {
        int result;
        String temp1 = this.versionString;
        if (!this.isFCS()) {
            temp1 = this.versionString.substring(0, this.versionString.indexOf("-"));
        }
        String temp2 = otherVersion.versionString;
        if (!otherVersion.isFCS()) {
            temp2 = otherVersion.versionString.substring(0, otherVersion.versionString.indexOf("-"));
        }
        if ((result = temp1.compareTo(temp2)) != 0) {
            return result;
        }
        if (this.isFCS()) {
            if (otherVersion.isFCS()) {
                return 0;
            }
            return 1;
        }
        if (otherVersion.isFCS()) {
            return -1;
        }
        return this.versionString.compareTo(otherVersion.versionString);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaVersion)) {
            return false;
        }
        JavaVersion version = (JavaVersion)obj;
        return this.versionString.equals(version.versionString);
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public String toString() {
        return this.versionString;
    }

    public static JavaVersion getCurrent() {
        return current;
    }
}

