/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import java.util.Locale;

public final class LocaleTools {
    public static Locale[] getCommonLocales() {
        return new Locale[]{Locale.GERMAN, Locale.ENGLISH, Locale.FRENCH, Locale.ITALIAN, Locale.CHINESE, Locale.UK, Locale.US};
    }

    public static Locale parseLocaleString(String localeString) {
        if (localeString == null) {
            return null;
        }
        if (localeString.trim().equals("")) {
            return null;
        }
        String[] tokens = localeString.split("_", 3);
        Locale result = tokens.length == 1 ? new Locale(tokens[0]) : (tokens.length == 2 ? new Locale(tokens[0], tokens[1]) : new Locale(tokens[0], tokens[1], tokens[2]));
        return result;
    }

    public static String getLocaleLabel(Locale locale) {
        String text;
        if (locale.getDisplayCountry() != null && locale.getDisplayCountry().length() > 0) {
            text = "%s (%s) [%s]";
            text = String.format(text, locale.getDisplayLanguage(), locale.getDisplayCountry(), locale.toString());
        } else {
            text = "%s [%s]";
            text = String.format(text, locale.getDisplayLanguage(), locale.toString());
        }
        return text;
    }

    private LocaleTools() {
    }
}

