/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerTools {
    public static String getLoggerName(Class<?> cls) {
        return LoggerTools.getLoggerName(cls.getName());
    }

    private static String getLoggerName(String className) {
        return className.replace("de.aristaflow.", "");
    }

    public static Logger getLogger(Class<?> cls) {
        Logger ret;
        String name = LoggerTools.getLoggerName(cls);
        while ((ret = Logger.getLogger(name)) == null) {
        }
        return ret;
    }

    public static Logger getLogger(Object object) {
        return LoggerTools.getLogger(object.getClass());
    }

    public static void logUnhandledException(Throwable exception) {
        String msg = "An unhandled exception has been detected!";
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement caller = null;
        int i = 0;
        while (i < stackTrace.length - 1) {
            if (stackTrace[i].getClassName().equals(LoggerTools.class.getName())) {
                caller = stackTrace[i + 1];
                break;
            }
            ++i;
        }
        if (caller != null) {
            Logger logger = Logger.getLogger(LoggerTools.getLoggerName(caller.getClassName()));
            logger.logp(Level.SEVERE, caller.getClassName(), caller.getMethodName(), msg, exception);
        } else {
            Logger logger = Logger.getLogger("adept2");
            logger.log(Level.SEVERE, msg, exception);
        }
    }

    public static void logVirtualMachineErrorSafely(VirtualMachineError vme, String backupMsg) {
        try {
            try {
                LoggerTools.logUnhandledException(vme);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
            catch (VirtualMachineError virtualMachineError) {
                System.err.println(backupMsg);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (VirtualMachineError virtualMachineError) {}
    }

    private LoggerTools() {
    }
}

