/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.NullArgumentException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class StackTraceTools {
    public static StackTraceElement[] tailTrim(StackTraceElement[] stackTrace, int trim) {
        if (stackTrace == null) {
            throw new NullArgumentException("The parameter 'stackTrace' must not be null!");
        }
        if (trim < 0) {
            throw new IllegalArgumentException("The parameter 'trim' must not be negative!");
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - trim];
        System.arraycopy(stackTrace, 0, newStackTrace, 0, newStackTrace.length);
        return newStackTrace;
    }

    public static StackTraceElement[] headTrim(StackTraceElement[] stackTrace, int trim) {
        if (stackTrace == null) {
            throw new NullArgumentException("The parameter 'stackTrace' must not be null!");
        }
        if (trim < 0) {
            throw new IllegalArgumentException("The parameter 'trim' must not be negative!");
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - trim];
        System.arraycopy(stackTrace, trim, newStackTrace, 0, newStackTrace.length);
        return newStackTrace;
    }

    public static StackTraceElement[] headTrim(StackTraceElement[] origStackTrace, Class<?> cls) {
        StackTraceElement[] stackTrace = origStackTrace;
        if (stackTrace == null) {
            throw new NullArgumentException("The parameter 'stackTrace' must not be null!");
        }
        if (cls == null) {
            throw new IllegalArgumentException("The parameter 'cls' must not be null!");
        }
        int trim = 0;
        String clsName = cls.getName();
        while (trim < stackTrace.length) {
            if (!stackTrace[trim].getClassName().equals(clsName)) break;
            ++trim;
        }
        if (trim > 0) {
            StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - trim];
            System.arraycopy(stackTrace, trim, newStackTrace, 0, newStackTrace.length);
            stackTrace = newStackTrace;
        }
        return stackTrace;
    }

    public static StackTraceElement[] join(StackTraceElement[] headStackTrace, StackTraceElement[] tailStackTrace) {
        if (headStackTrace == null) {
            throw new NullArgumentException("The parameter 'headStackTrace' must not be null!");
        }
        if (tailStackTrace == null) {
            throw new NullArgumentException("The parameter 'tailStackTrace' must not be null!");
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[headStackTrace.length + tailStackTrace.length];
        System.arraycopy(headStackTrace, 0, newStackTrace, 0, headStackTrace.length);
        System.arraycopy(tailStackTrace, 0, newStackTrace, headStackTrace.length, tailStackTrace.length);
        return newStackTrace;
    }

    public static StackTraceElement[] join(StackTraceElement[] headStackTrace, int tailTrimOfHead, StackTraceElement[] tailStackTrace, int headTrimOfTail) {
        if (headStackTrace == null) {
            throw new NullArgumentException("The parameter 'headStackTrace' must not be null!");
        }
        if (tailStackTrace == null) {
            throw new NullArgumentException("The parameter 'tailStackTrace' must not be null!");
        }
        if (tailTrimOfHead < 0) {
            throw new IllegalArgumentException("The parameter 'headTrim' must not be negative!");
        }
        if (headTrimOfTail < 0) {
            throw new IllegalArgumentException("The parameter 'tailTrim' must not be negative!");
        }
        int headSize = headStackTrace.length - tailTrimOfHead;
        int tailSize = tailStackTrace.length - headTrimOfTail;
        StackTraceElement[] newStackTrace = new StackTraceElement[headSize + tailSize];
        System.arraycopy(headStackTrace, 0, newStackTrace, 0, headSize);
        System.arraycopy(tailStackTrace, headTrimOfTail, newStackTrace, headSize, tailSize);
        return newStackTrace;
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String stackTracesToString(StackTraceElement[] trace) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < trace.length) {
            ret.append("\tat ");
            ret.append(trace[i]);
            ret.append("\n");
            ++i;
        }
        ret.deleteCharAt(ret.length() - 1);
        return ret.toString();
    }

    public static void printStackTrace() {
        Throwable dummy = new Throwable();
        dummy.printStackTrace(System.out);
    }

    private StackTraceTools() {
    }
}

