/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class StreamTools {
    public static void copyStreamToStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        ArgChecks.checkForNull(in, "in");
        ArgChecks.checkForNull(out, "out");
        byte[] buffer = new byte[16384];
        while ((bytesRead = in.read(buffer)) > -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    public static byte[] copyStreamToByteArray(InputStream in) throws IOException {
        ArgChecks.checkForNull(in, "in");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamTools.copyStreamToStream(in, out);
        out.close();
        return out.toByteArray();
    }

    public static final byte[] toByteArray(Serializable object) throws IOException {
        OutputStream close = null;
        ByteArrayOutputStream baos = null;
        try {
            close = new ByteArrayOutputStream();
            baos = close;
            close = new ObjectOutputStream(close);
            ObjectOutputStream oos = (ObjectOutputStream)close;
            oos.writeObject(object);
        }
        finally {
            if (close != null) {
                close.close();
            }
        }
        byte[] ret = baos.toByteArray();
        return ret;
    }

    public static final Serializable fromByteArray(byte[] object) throws IOException, ClassNotFoundException {
        Serializable ret;
        InputStream close = null;
        try {
            close = new ByteArrayInputStream(object);
            close = new ObjectInputStream(close);
            ObjectInputStream ois = (ObjectInputStream)close;
            ret = (Serializable)ois.readObject();
        }
        finally {
            if (close != null) {
                close.close();
            }
        }
        return ret;
    }
}

