/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class StringTools {
    public static boolean equal(String str1, Object str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static String join(String glue, Object ... tokens) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Object[] objectArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Object token = objectArray[n2];
            if (!first) {
                sb.append(glue);
            } else {
                first = false;
            }
            sb.append(token);
            ++n2;
        }
        return sb.toString();
    }

    public static String join(String glue, String ... tokens) {
        return StringTools.join(glue, (Object[])tokens);
    }

    public static String join(String glue, List<String> tokens) {
        ArgChecks.checkForNull(glue, "glue");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                sb.append(glue);
            } else {
                first = false;
            }
            sb.append((Object)token);
        }
        return sb.toString();
    }

    public static String[] join(String glue, String[] ... tokens) {
        ArgChecks.checkForNull(glue, "glue");
        ArgChecks.checkForNulls((Object[])tokens, "tokens");
        int tokenArrayLength = tokens[0].length;
        int i = 1;
        while (i < tokens.length) {
            if (tokens[i].length != tokenArrayLength) {
                String msg = "all arrays in 'tokens' must have the same length!";
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        String[] result = new String[tokens[0].length];
        String[] temp = new String[tokens.length];
        int y = 0;
        while (y < result.length) {
            int x = 0;
            while (x < tokens.length) {
                temp[x] = tokens[x][y];
                ++x;
            }
            result[y] = StringTools.join(glue, temp);
            ++y;
        }
        return result;
    }

    public static String[] prefix(String prefix, String ... strings) {
        String[] res = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            res[i] = String.valueOf(prefix) + strings[i];
            ++i;
        }
        return res;
    }

    public static List<String> prefix(String prefix, List<String> strings) {
        ArrayList<String> res = new ArrayList<String>();
        for (String string : strings) {
            res.add(String.valueOf(prefix) + string);
        }
        return res;
    }

    public static String[] suffix(String suffix, String ... strings) {
        String[] res = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            res[i] = String.valueOf(strings[i]) + suffix;
            ++i;
        }
        return res;
    }

    public static List<String> suffix(String suffix, List<String> strings) {
        ArrayList<String> res = new ArrayList<String>();
        for (String string : strings) {
            res.add(String.valueOf(string) + suffix);
        }
        return res;
    }

    public static String[] surround(String prefix, String suffix, String ... strings) {
        String[] res = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            res[i] = String.valueOf(prefix) + strings[i] + suffix;
            ++i;
        }
        return res;
    }

    public static List<String> surround(String prefix, String suffix, List<String> strings) {
        ArrayList<String> res = new ArrayList<String>();
        for (String string : strings) {
            res.add(String.valueOf(prefix) + string + suffix);
        }
        return res;
    }

    public static String repeat(String string, int times) {
        String result;
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNegative(times, "times");
        switch (times) {
            case 0: {
                result = "";
                break;
            }
            case 1: {
                result = string;
                break;
            }
            default: {
                int requiredSize = string.length() * times;
                StringBuilder sb = new StringBuilder(requiredSize);
                int i = 0;
                while (i < times) {
                    sb.append(string);
                    ++i;
                }
                result = sb.toString();
            }
        }
        return result;
    }

    public static String repeat(String string, String glue, int times) {
        String result;
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNull(glue, "glue");
        ArgChecks.checkForNegative(times, "times");
        switch (times) {
            case 0: {
                result = "";
                break;
            }
            case 1: {
                result = string;
                break;
            }
            default: {
                int requiredSize = string.length() * times + glue.length() * (times - 1);
                StringBuilder sb = new StringBuilder(requiredSize);
                boolean first = true;
                int i = 0;
                while (i < times) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(glue);
                    }
                    sb.append(string);
                    ++i;
                }
                result = sb.toString();
            }
        }
        return result;
    }

    public static String pad(String string, int length) {
        return StringTools.pad(string, length, " ");
    }

    public static String lpad(String string, int length) {
        return StringTools.lpad(string, length, " ");
    }

    public static String rpad(String string, int length) {
        return StringTools.rpad(string, length, " ");
    }

    public static String pad(String string, int length, String padString) {
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNull(padString, "padString");
        int padLength = length - string.length();
        if (padLength > 0) {
            int lpadLength = padLength / 2;
            int rpadLength = padLength - lpadLength;
            StringBuilder sb = new StringBuilder(length);
            int i = 0;
            while (i < lpadLength) {
                sb.append(padString.charAt(i % padString.length()));
                ++i;
            }
            sb.append(string);
            i = 0;
            while (i < rpadLength) {
                sb.append(padString.charAt(i % padString.length()));
                ++i;
            }
            return sb.toString();
        }
        return string;
    }

    public static String lpad(String string, int length, String padString) {
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNull(padString, "padString");
        int padLength = length - string.length();
        if (padLength > 0) {
            StringBuilder sb = new StringBuilder(length);
            int i = 0;
            while (i < padLength) {
                sb.append(padString.charAt(i % padString.length()));
                ++i;
            }
            sb.append(string);
            return sb.toString();
        }
        return string;
    }

    public static String rpad(String string, int length, String padString) {
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNull(padString, "padString");
        int padLength = length - string.length();
        if (padLength > 0) {
            StringBuilder sb = new StringBuilder(length);
            sb.append(string);
            int i = 0;
            while (i < padLength) {
                sb.append(padString.charAt(i % padString.length()));
                ++i;
            }
            return sb.toString();
        }
        return string;
    }

    public static String trim(String string) {
        int begin = 0;
        int end = string.length();
        while (begin < end && Character.isWhitespace(string.charAt(begin))) {
            ++begin;
        }
        while (begin < end && Character.isWhitespace(string.charAt(end - 1))) {
            --end;
        }
        return begin > 0 || end < string.length() ? string.substring(begin, end) : string;
    }

    public static String ltrim(String string) {
        int begin = 0;
        int end = string.length();
        while (begin < end && Character.isWhitespace(string.charAt(begin))) {
            ++begin;
        }
        return begin > 0 ? string.substring(begin) : string;
    }

    public static String rtrim(String string) {
        int begin = 0;
        int end = string.length();
        while (begin < end && Character.isWhitespace(string.charAt(end - 1))) {
            --end;
        }
        return end < string.length() ? string.substring(0, end) : string;
    }

    public static String trim(String string, String trimChars) {
        int begin = 0;
        int end = string.length();
        while (begin < end && trimChars.indexOf(string.charAt(begin)) > -1) {
            ++begin;
        }
        while (begin < end && trimChars.indexOf(string.charAt(end - 1)) > -1) {
            --end;
        }
        return begin > 0 || end < string.length() ? string.substring(begin, end) : string;
    }

    public static String ltrim(String string, String trimChars) {
        int begin = 0;
        int end = string.length();
        while (begin < end && trimChars.indexOf(string.charAt(begin)) > -1) {
            ++begin;
        }
        return begin > 0 ? string.substring(begin) : string;
    }

    public static String rtrim(String string, String trimChars) {
        int begin = 0;
        int end = string.length();
        while (begin < end && trimChars.indexOf(string.charAt(end - 1)) > -1) {
            --end;
        }
        return end < string.length() ? string.substring(0, end) : string;
    }

    public static String trunc(String string, int length) {
        ArgChecks.checkForNull(string, "string");
        ArgChecks.checkForNegative(length, "length");
        return string.length() > length ? string.substring(0, length) : string;
    }

    public static byte[] toByteArray(String string, String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buffer, encoding);
        try {
            ((Writer)writer).append(string);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException", ex);
        }
        return buffer.toByteArray();
    }

    public static String fromByteArray(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), encoding);
        StringBuilder string = new StringBuilder();
        try {
            int charsRead;
            char[] buffer = new char[1024];
            while ((charsRead = reader.read(buffer)) > -1) {
                string.append(buffer, 0, charsRead);
            }
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException", ex);
        }
        return string.toString();
    }

    private StringTools() {
    }
}

