/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.i18n;

import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.time.nl.LocalPublicHolidays;
import de.aristaflow.adept2.util.time.nl.PublicHolidays;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AristaFlowBundle
extends ResourceBundle {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected Map<String, Class<?>> i18nClasses = new HashMap(1);

    public AristaFlowBundle() {
        this.i18nClasses.put(PublicHolidays.class.getCanonicalName(), LocalPublicHolidays.class);
    }

    @Override
    public Enumeration<String> getKeys() {
        return new Enumeration<String>(){
            int current = 0;
            String[] keys;
            {
                this.keys = AristaFlowBundle.this.i18nClasses.keySet().toArray(new String[AristaFlowBundle.this.i18nClasses.size()]);
            }

            @Override
            public boolean hasMoreElements() {
                return this.current < this.keys.length;
            }

            @Override
            public String nextElement() {
                return this.keys[this.current++];
            }
        };
    }

    @Override
    protected Object handleGetObject(String key) {
        Object ret = null;
        Class<?> cls = this.i18nClasses.get(key);
        if (cls != null) {
            try {
                ret = cls.newInstance();
            }
            catch (InstantiationException ie) {
                this.logger.log(Level.SEVERE, String.format("Can not instantiate i18n-class '%1$s' for '%2$s' since it is not instantiable. Delegating to the parent bundle.", cls, key), ie);
                ret = this.parent.getObject(key);
            }
            catch (IllegalAccessException iae) {
                this.logger.log(Level.SEVERE, String.format("Can not access the (constructor of) i18n-class'%1$s' for '%2$s'. Delegating to the parentbundle.", cls, key), iae);
                ret = this.parent.getObject(key);
            }
        }
        return ret;
    }

    public static List<String> getBundleKeyNames(Locale locale) {
        boolean variantSet;
        ArrayList<String> result = new ArrayList<String>(3);
        boolean languageSet = locale.getLanguage().length() != 0;
        boolean countrySet = locale.getCountry().length() != 0;
        boolean bl = variantSet = locale.getVariant().length() != 0;
        if (!(languageSet || countrySet || variantSet)) {
            return result;
        }
        StringBuffer temp = new StringBuffer();
        temp.append(locale.getLanguage());
        if (languageSet) {
            result.add(temp.toString());
        }
        if (!countrySet && !variantSet) {
            return result;
        }
        temp.append('_');
        temp.append(locale.getCountry());
        if (countrySet) {
            result.add(temp.toString());
        }
        if (!variantSet) {
            return result;
        }
        temp.append('_');
        temp.append(locale.getVariant());
        result.add(temp.toString());
        return result;
    }
}

