/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.locking;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LockException;

public class AcquireLockException
extends LockException {
    private static final long serialVersionUID = 124670101777879464L;
    private final Object lockAcquiringObject;
    private final String acquiringLockType;

    public AcquireLockException(Object lockedObject, Object lockAcquiringObject, String lockType) {
        this(lockedObject, lockType, lockAcquiringObject, lockType);
    }

    public AcquireLockException(Object lockedObject, String currentLockType, Object lockAcquiringObject, String acquiringLockType) {
        super(lockedObject, currentLockType);
        ArgChecks.checkForNull(acquiringLockType, "acquiringLockType");
        this.lockAcquiringObject = lockAcquiringObject;
        this.acquiringLockType = acquiringLockType;
    }

    public AcquireLockException(Object lockedObject, Object lockOwner, Object lockAcquiringObject, String lockType) {
        this(lockedObject, lockOwner, lockType, lockAcquiringObject, lockType);
    }

    public AcquireLockException(Object lockedObject, Object lockOwner, String currentLockType, Object lockAcquiringObject, String acquiringLockType) {
        super(lockedObject, lockOwner, currentLockType);
        ArgChecks.checkForNull(acquiringLockType, "acquiringLockType");
        this.lockAcquiringObject = lockAcquiringObject;
        this.acquiringLockType = acquiringLockType;
    }

    public Object getAcquiringObject() {
        return this.lockAcquiringObject;
    }

    public String getAcquiringLockType() {
        return this.acquiringLockType;
    }

    @Override
    public String getMessage() {
        String aLockType = this.getAcquiringLockType().equals(this.getLockType()) ? "" : String.format(" ('%s')", this.getAcquiringLockType());
        return String.format("'%s' is already locked (%s) by '%s' and therefore the lock%s can not be acquired by '%s'.", this.getLockedObject(), this.getLockType(), this.getLockOwner(), aLockType, this.getAcquiringObject());
    }
}

