/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.locking;

import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ReentrantLock;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ObjectEqualityLockCount
implements ReentrantLock.LockCountManager<Object> {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Map<Object, Integer> objectLockCount = new HashMap<Object, Integer>();

    @Override
    public synchronized boolean hasLock(Object object) {
        return this.objectLockCount.containsKey(object);
    }

    @Override
    public synchronized boolean hasLocks() {
        return !this.objectLockCount.isEmpty();
    }

    @Override
    public synchronized String getLockOwner() {
        String ret = "";
        if (!this.objectLockCount.keySet().isEmpty()) {
            Object lockOwningObject = this.objectLockCount.keySet().toArray()[0];
            ret = lockOwningObject.toString();
        }
        return ret;
    }

    @Override
    public synchronized int increaseAndGetLockCount(Object object) {
        String msg;
        int ret;
        if (this.objectLockCount.containsKey(object)) {
            ret = this.objectLockCount.get(object);
            msg = String.format("'%s' acquired now has lock %d times.", object, ++ret);
        } else {
            ret = 1;
            msg = String.format("'%s' created lock, acquired once.", object);
        }
        this.objectLockCount.put(object, ret);
        this.logger.fine(msg);
        return ret;
    }

    @Override
    public synchronized int decreaseAndGetLockCount(Object object) {
        String msg;
        int ret = Integer.MIN_VALUE;
        if (this.objectLockCount.containsKey(object)) {
            ret = this.objectLockCount.get(object);
            if (--ret > 0) {
                this.objectLockCount.put(object, ret);
                msg = String.format("'%s' unlocked once, lock held %d times.", object, ret);
            } else {
                this.objectLockCount.remove(object);
                msg = String.format("'%s' unlocked and removed lock.", object);
            }
        } else {
            msg = String.format("'%s' tries to decrease lock but no lock exists.", object);
        }
        this.logger.fine(msg);
        return ret;
    }
}

