/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.locking;

import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ReentrantLock;
import de.aristaflow.adept2.util.locking.ReleaseLockException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectLockManager<O, L> {
    protected final Map<O, ReentrantLock<L>> objectLocks = new HashMap<O, ReentrantLock<L>>();
    protected final Map<O, Integer> waitingLockCount = new HashMap<O, Integer>();
    protected final Class<? extends ReentrantLock.LockCountManager<? super L>> lockCountManager;
    protected final Class<? extends ReentrantLock<L>> lock;
    protected final String lockType;
    protected final Logger logger;

    public ObjectLockManager(Class<? extends ReentrantLock.LockCountManager<? super L>> lockCountManager, Class<? extends ReentrantLock<L>> lock, String lockType) throws InvocationTargetException {
        this.lockCountManager = lockCountManager;
        this.lock = lock;
        this.lockType = lockType;
        this.logger = LoggerTools.getLogger(this);
        try {
            Constructor<ReentrantLock<L>> constr = this.lock.getConstructor(Class.class, Boolean.TYPE);
            constr.newInstance(lockCountManager, false);
        }
        catch (SecurityException se) {
            String msg = "Could not retrieve constructor of provided reentrant lock class. Please provide an accessible class with an accessible constructor.";
            throw new InvocationTargetException(se, msg);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "Provided reentrant lock class does not declare an appropriate constructor. Please provide a constructor accepting Class<? extends LockCountManager<? super L>> and boolean.";
            throw new InvocationTargetException(nsme, msg);
        }
        catch (InstantiationException ie) {
            String msg = "Could not instantiate reentrant lock since it is an abstract class. Please provide an instantiable class.";
            throw new InvocationTargetException(ie, msg);
        }
        catch (IllegalAccessException iae) {
            String msg = "Could not access constructor of provided reentrant lock class. Please provide an accessible class with an accessible constructor.";
            throw new InvocationTargetException(iae, msg);
        }
        catch (IllegalArgumentException iae) {
            String msg = "The constructor of the provided reentrant lock class has the wrong parameter types. Please provide a constructor accepting Class<? extends LockCountManager<? super L>> and boolean.";
            throw new InvocationTargetException(iae, msg);
        }
    }

    public void getLockForObject(boolean writeLock, L lockingObject, O lockedObject) throws InterruptedException {
        try {
            this.getLockForObject(writeLock, lockingObject, lockedObject, 0L);
        }
        catch (TimeoutException timeoutException) {
            this.logger.log(Level.SEVERE, "Congratulations. You have reached the time when System.currentTimeMillis() exactly equals Long.MAX_VALUE.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockForObject(boolean writeLock, L lockingObject, O lockedObject, long timeout) throws InterruptedException, TimeoutException {
        String msg;
        ReentrantLock<L> lock = null;
        try {
            ObjectLockManager objectLockManager = this;
            synchronized (objectLockManager) {
                if (this.objectLocks.containsKey(lockedObject)) {
                    lock = this.objectLocks.get(lockedObject);
                    if (this.logger.isLoggable(Level.FINER)) {
                        msg = String.format("Lock ('%s') of type '%s' already exists for object '%s'. Registering '%s' to prevent removal of this lock when released.", lock, this.lockType, lockedObject, lockingObject);
                        this.logger.finer(msg);
                    }
                } else {
                    if (this.logger.isLoggable(Level.FINER)) {
                        msg = String.format("Creating new lock of type '%s' for object '%s'.", this.lockType, lockedObject);
                        this.logger.finer(msg);
                    }
                    try {
                        Constructor<ReentrantLock<L>> constr = this.lock.getConstructor(Class.class, Boolean.TYPE);
                        lock = constr.newInstance(this.lockCountManager, false);
                    }
                    catch (SecurityException se) {
                        msg = "Could not access constructor of provided reentrant lock class. Please provide one with an accessible constructor.";
                        throw new RuntimeException(msg, se);
                    }
                    catch (NoSuchMethodException nsme) {
                        msg = "Provided reentrant lock class does not declare an appropriate constructor. Please provide a constructor accepting Class<? extends LockCountManager<L>> and boolean.";
                        throw new RuntimeException(msg, nsme);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could not instantiate reentrant lock since it is an abstract class.Please provide an instantiable class.";
                        throw new RuntimeException(msg, ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could not access constructor of provided reentrant lock class. Please provide one with an accessible constructor.";
                        throw new RuntimeException(msg, iae);
                    }
                    catch (IllegalArgumentException iae) {
                        msg = "The constructor of the provided reentrant lock class has the wrong parameter types. Please provide a constructor accepting Class<? extends LockCountManager<L>> and boolean.";
                        throw new RuntimeException(msg, iae);
                    }
                    catch (InvocationTargetException ite) {
                        msg = "The constructor of the provided reentrant lock class has thrown an exception.";
                        throw new RuntimeException(msg, ite);
                    }
                    this.objectLocks.put(lockedObject, lock);
                }
                this.incrementLockWaitCount(lockedObject);
            }
            if (writeLock) {
                lock.writeLock().lock(lockingObject, timeout);
            } else {
                lock.readLock().lock(lockingObject, timeout);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                msg = String.format("Object '%s' locked (%s) by '%s' for %s having lock '%s'.", lockedObject, lockingObject, this.lockType, writeLock ? "writing" : "reading", lock);
                this.logger.fine(msg);
            }
        }
        catch (Throwable throwable) {
            ObjectLockManager objectLockManager = this;
            synchronized (objectLockManager) {
                this.decrementLockWaitCount(lockedObject);
                if (this.logger.isLoggable(Level.FINER)) {
                    String msg2 = String.format("Lock ('%s') of type '%s' for object '%s' acquired. Deregistered '%s' to allow removal again.", lock, this.lockType, lockedObject, lockingObject);
                    this.logger.finer(msg2);
                }
            }
            throw throwable;
        }
        ObjectLockManager objectLockManager = this;
        synchronized (objectLockManager) {
            this.decrementLockWaitCount(lockedObject);
            if (this.logger.isLoggable(Level.FINER)) {
                msg = String.format("Lock ('%s') of type '%s' for object '%s' acquired. Deregistered '%s' to allow removal again.", lock, this.lockType, lockedObject, lockingObject);
                this.logger.finer(msg);
            }
        }
    }

    public synchronized boolean hasLock(boolean writeLock, L lockingObject, O lockedObject) {
        ReentrantLock<L> lock = this.objectLocks.get(lockedObject);
        return lock != null && (writeLock ? lock.writeLock().hasLock(lockingObject) : lock.readLock().hasLock(lockingObject));
    }

    public synchronized void unlockObject(boolean writeLock, L lockingObject, O lockedObject) throws LockException {
        String msg;
        boolean lockWaiterNotified;
        ReentrantLock<L> lock = this.objectLocks.get(lockedObject);
        if (lock == null) {
            String msg2 = String.format("Object '%s' is not locked, unlocking impossible.", lockedObject);
            this.logger.severe(msg2);
            throw new ReleaseLockException(lockedObject, false, lockingObject, this.lockType);
        }
        if (writeLock && !lock.writeLock().hasLock(lockingObject)) {
            String rwType;
            String otherLocking;
            if (lock.isWriteLocked()) {
                otherLocking = lock.writeLock().currentLockingObject();
                rwType = "writing";
            } else {
                otherLocking = lock.readLock().currentLockingObject();
                rwType = "reading";
            }
            String msg3 = String.format("Object '%s' is not locked for writing by '%s', but it is locked by '%s' for '%s'.", lockedObject, lockingObject, otherLocking, rwType);
            this.logger.severe(msg3);
            throw new ReleaseLockException(lockedObject, otherLocking, lockingObject, this.lockType);
        }
        if (!writeLock && !lock.readLock().hasLock(lockingObject)) {
            String rwType;
            String otherLocking;
            if (lock.isWriteLocked()) {
                otherLocking = lock.writeLock().currentLockingObject();
                rwType = "writing";
            } else {
                otherLocking = lock.readLock().currentLockingObject();
                rwType = "reading";
            }
            String msg4 = String.format("Object '%s' is not locked for reading by '%s', but it is locked by '%s' for %s.", lockedObject, lockingObject, otherLocking, rwType);
            this.logger.severe(msg4);
            throw new ReleaseLockException(lockedObject, otherLocking, lockingObject, this.lockType);
        }
        boolean bl = lockWaiterNotified = writeLock ? lock.writeLock().unlock(lockingObject) : lock.readLock().unlock(lockingObject);
        if (this.logger.isLoggable(Level.FINE)) {
            msg = String.format("Object '%s' has been unlocked from %s by '%s' releasing lock '%s'.", lockedObject, writeLock ? "writing" : "reading", lockingObject, lock);
            this.logger.fine(msg);
        }
        if (!(lockWaiterNotified || lock.writeLock().hasLock(lockingObject) || lock.readLock().isLocked() || this.getLockWaitCount(lockedObject) != 0)) {
            this.objectLocks.remove(lockedObject);
            if (this.logger.isLoggable(Level.FINER)) {
                msg = String.format("Lock ('%s') for object '%s' removed since there are no waiters.", lock, lockedObject);
                this.logger.finer(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int incrementLockWaitCount(O object) {
        int ret;
        Map<O, Integer> map = this.waitingLockCount;
        synchronized (map) {
            ret = this.waitingLockCount.containsKey(object) ? this.waitingLockCount.get(object) + 1 : 1;
            this.waitingLockCount.put(object, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLockWaitCount(O object) {
        int ret;
        Map<O, Integer> map = this.waitingLockCount;
        synchronized (map) {
            ret = this.waitingLockCount.containsKey(object) ? this.waitingLockCount.get(object) : 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int decrementLockWaitCount(O object) {
        int ret;
        Map<O, Integer> map = this.waitingLockCount;
        synchronized (map) {
            ret = this.waitingLockCount.get(object) - 1;
            if (ret > 0) {
                this.waitingLockCount.put(object, ret);
            } else {
                this.waitingLockCount.remove(object);
            }
        }
        return ret;
    }
}

