/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.locking;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReentrantLock<T> {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Lock<T> writeLock;
    protected final Lock<T> readLock;

    public ReentrantLock(Class<? extends LockCountManager<? super T>> lockCountManager, boolean exclusive) throws InstantiationException, IllegalAccessException {
        if (exclusive) {
            this.writeLock = new Lock<T>(lockCountManager.newInstance(), this.logger);
            this.readLock = this.writeLock;
        } else {
            this.writeLock = new WriteLock<T>(lockCountManager.newInstance(), this.logger);
            this.readLock = new ReadLock<T>(lockCountManager.newInstance(), this.logger);
        }
    }

    public boolean isReadLocked() {
        return this.readLock.isLocked();
    }

    public boolean isWriteLocked() {
        return this.writeLock.isLocked();
    }

    public Lock<T> readLock() {
        return this.readLock;
    }

    public Lock<T> writeLock() {
        return this.writeLock;
    }

    public static class Lock<U> {
        protected final Logger logger;
        protected final LockCountManager<? super U> lockCountManager;
        protected final AtomicInteger waitersForLock = new AtomicInteger(0);

        protected Lock(LockCountManager<? super U> lockCountManager, Logger logger) {
            this.lockCountManager = lockCountManager;
            this.logger = logger;
        }

        public void lock(U object) throws InterruptedException {
            try {
                this.lock(object, 0L);
            }
            catch (TimeoutException timeoutException) {
                this.logger.log(Level.SEVERE, "Congratulations. You have reached the time when System.currentTimeMillis() exactly equals Long.MAX_VALUE.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(U object, long timeout) throws InterruptedException, TimeoutException {
            int lockCount;
            this.logger.fine(String.format("'%s' tries to acquire the lock '%s' with a timeout of %d.", object, this, timeout));
            this.waitersForLock.incrementAndGet();
            long endWait = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            try {
                Lock lock = this;
                synchronized (lock) {
                    while (this.isLocked() && !this.hasLock(object) && System.currentTimeMillis() < endWait) {
                        this.wait(timeout);
                    }
                    if (this.isLocked() && !this.hasLock(object) && System.currentTimeMillis() >= endWait) {
                        String msg = String.format("Retrieved a timeout while trying to acquire the lock '%s' on '%s' with a timeout of %d. '%s' currently owns the lock.", this, object, timeout, this.currentLockingObject());
                        throw new TimeoutException(msg);
                    }
                    lockCount = this.lockCountManager.increaseAndGetLockCount(object);
                }
            }
            finally {
                this.waitersForLock.decrementAndGet();
            }
            this.logger.info(String.format("'%s' has acquired the lock '%s' %d times.", object, this, lockCount));
        }

        public synchronized boolean hasLock(U object) {
            return this.lockCountManager.hasLock(object);
        }

        public synchronized boolean isLocked() {
            return this.lockCountManager.hasLocks();
        }

        public synchronized int objectsWaitingToLock() {
            return this.waitersForLock.intValue();
        }

        public synchronized boolean unlock(U object) {
            boolean ret = false;
            this.logger.fine(String.format("'%s' tries to unlock '%s'.", object, this));
            if (!this.hasLock(object)) {
                String message = "Object '%s' is not the owner of the lock and may therefore not release the lock!";
                throw new IllegalArgumentException(String.format(message, object));
            }
            int lockCount = this.lockCountManager.decreaseAndGetLockCount(object);
            if (this.notificationRequired()) {
                ret = true;
                this.notifyAll();
            }
            this.logger.info(String.format("'%s' has unlocked '%s'. The lock is still held %d times.", object, this, lockCount));
            return ret;
        }

        protected boolean notificationRequired() {
            return !this.lockCountManager.hasLocks() && this.waitersForLock.intValue() > 0;
        }

        public synchronized String currentLockingObject() {
            return this.lockCountManager.getLockOwner();
        }
    }

    public static interface LockCountManager<L> {
        public boolean hasLock(L var1);

        public boolean hasLocks();

        public String getLockOwner();

        public int increaseAndGetLockCount(L var1);

        public int decreaseAndGetLockCount(L var1);
    }

    protected class ReadLock<U>
    extends Lock<U> {
        protected ReadLock(LockCountManager<? super U> lockCountManager, Logger logger) {
            super(lockCountManager, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock(U object, long timeout) throws InterruptedException, TimeoutException {
            int lockCount;
            this.logger.fine(String.format("'%s' tries to acquire the read lock '%s' ('%s') with a timeout of %d.", object, this, ReentrantLock.this, timeout));
            this.waitersForLock.incrementAndGet();
            long endWait = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            try {
                Lock lock = ReentrantLock.this.writeLock();
                synchronized (lock) {
                    while ((ReentrantLock.this.isWriteLocked() || ReentrantLock.this.writeLock().objectsWaitingToLock() > 0) && System.currentTimeMillis() < endWait) {
                        ReentrantLock.this.writeLock().wait(timeout);
                    }
                    if ((ReentrantLock.this.isWriteLocked() || ReentrantLock.this.writeLock().objectsWaitingToLock() > 0) && System.currentTimeMillis() >= endWait) {
                        String msg = String.format("Retrieved a timeout while trying to acquire the read lock '%s' ('%s') on '%s' with a timeout of %d. '%s' currently owns a write lock.", this, ReentrantLock.this, object, timeout, ReentrantLock.this.writeLock().currentLockingObject());
                        throw new TimeoutException(msg);
                    }
                    lockCount = this.lockCountManager.increaseAndGetLockCount(object);
                }
            }
            finally {
                this.waitersForLock.decrementAndGet();
            }
            this.logger.info(String.format("'%s' has acquired the read lock '%s' ('%s') %d times.", object, this, ReentrantLock.this, lockCount));
        }

        @Override
        protected boolean notificationRequired() {
            return !this.lockCountManager.hasLocks() && (this.waitersForLock.intValue() > 0 || ReentrantLock.this.writeLock().waitersForLock.intValue() > 0);
        }
    }

    protected class WriteLock<U>
    extends Lock<U> {
        protected WriteLock(LockCountManager<? super U> lockCountManager, Logger logger) {
            super(lockCountManager, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock(U object, long origTimeout) throws InterruptedException, TimeoutException {
            int lockCount;
            long timeout = origTimeout;
            this.logger.fine(String.format("'%s' tries to acquire the write lock '%s' ('%s') with a timeout of %d.", object, this, ReentrantLock.this, timeout));
            this.waitersForLock.incrementAndGet();
            long endWait = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            try {
                WriteLock writeLock = ReentrantLock.this.readLock();
                synchronized (writeLock) {
                    while (ReentrantLock.this.isReadLocked() && System.currentTimeMillis() < endWait) {
                        ReentrantLock.this.readLock().wait(timeout);
                    }
                }
                if (ReentrantLock.this.isReadLocked() && System.currentTimeMillis() >= endWait) {
                    String msg = String.format("Retrieved a timeout while trying to acquire the write lock '%s' ('%s') on '%s' with a timeout of %d. '%s' currently owns a read lock.", this, ReentrantLock.this, object, timeout, ReentrantLock.this.readLock().currentLockingObject());
                    throw new TimeoutException(msg);
                }
                if (timeout > 0L) {
                    timeout = endWait - System.currentTimeMillis();
                }
                writeLock = this;
                synchronized (writeLock) {
                    while (ReentrantLock.this.isWriteLocked() && !this.hasLock(object) && endWait > System.currentTimeMillis()) {
                        this.wait(timeout);
                    }
                    if (ReentrantLock.this.isWriteLocked() && !this.hasLock(object) && endWait <= System.currentTimeMillis()) {
                        String msg = String.format("Retrieved a timeout while trying to acquire the write lock '%s' ('%s') on '%s' with a timeout of %d. '%s' currently owns a write lock.", this, ReentrantLock.this, object, timeout, this.currentLockingObject());
                        throw new TimeoutException(msg);
                    }
                    lockCount = this.lockCountManager.increaseAndGetLockCount(object);
                }
            }
            finally {
                this.waitersForLock.decrementAndGet();
            }
            this.logger.info(String.format("'%s' has acquired the write lock '%s' ('%s') %d times.", object, this, ReentrantLock.this, lockCount));
        }

        @Override
        protected boolean notificationRequired() {
            return !this.lockCountManager.hasLocks() && (this.waitersForLock.intValue() > 0 || ReentrantLock.this.readLock().waitersForLock.intValue() > 0);
        }
    }
}

