/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.locking;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LockException;

public class ReleaseLockException
extends LockException {
    private static final long serialVersionUID = 4914901835657422952L;
    protected final boolean locked;
    protected final Object lockReleasingObject;

    public ReleaseLockException(Object lockedObject, boolean locked, Object lockReleasingObject, String lockType) {
        super(lockedObject, lockType);
        ArgChecks.checkForNull(lockReleasingObject, "lockReleasingObject");
        this.lockReleasingObject = lockReleasingObject;
        this.locked = locked;
    }

    public ReleaseLockException(Object lockedObject, Object lockOwner, Object lockReleasingObject, String lockType) {
        super(lockedObject, lockOwner, lockType);
        ArgChecks.checkForNull(lockReleasingObject, "lockReleasingObject");
        this.lockReleasingObject = lockReleasingObject;
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Object getLockReleasingObject() {
        return this.lockReleasingObject;
    }

    @Override
    public String getMessage() {
        String locker = this.getLockOwner() != null ? String.format(" but by '%s'", this.getLockOwner()) : " but by an unknown object";
        return String.format("'%s' is not locked (%s) by '%s'%s and therefore the lock can not be released.", this.getLockedObject(), this.getLockType(), this.lockReleasingObject, this.locked ? locker : "");
    }
}

