/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OvertrustfulSSLSocketFactory
extends SSLSocketFactory {
    private static volatile SSLSocketFactory singleton;
    private static final Object syncObject;
    private SSLSocketFactory wrappedFactory;

    static {
        syncObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getDefault() {
        if (singleton == null) {
            Object object = syncObject;
            synchronized (object) {
                if (singleton == null) {
                    try {
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(null, new TrustManager[]{new OvertrustfulTrustManager()}, null);
                        singleton = new OvertrustfulSSLSocketFactory(context.getSocketFactory());
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (KeyManagementException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return singleton;
    }

    private OvertrustfulSSLSocketFactory(SSLSocketFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrappedFactory.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.wrappedFactory.createSocket(address, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.wrappedFactory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.wrappedFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.wrappedFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.wrappedFactory.createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.wrappedFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.wrappedFactory.getSupportedCipherSuites();
    }

    public static /* bridge */ /* synthetic */ SocketFactory getDefault() {
        return OvertrustfulSSLSocketFactory.getDefault();
    }

    private static class OvertrustfulTrustManager
    implements X509TrustManager {
        OvertrustfulTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

