/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool;

import de.aristaflow.adept2.util.objectpool.ObjectPool;

public abstract class AbstractObjectWrapper<T, E extends Exception> {
    private ObjectPool<T, E> objectPool;
    private T object;
    private long lastActiveTime = System.currentTimeMillis();

    protected AbstractObjectWrapper(ObjectPool<T, E> objectPool, T pooledObject) {
        if (objectPool == null) {
            throw new IllegalArgumentException("The parameter 'p_objectPool' must not be null!");
        }
        if (pooledObject == null) {
            throw new IllegalArgumentException("The parameter 'p_pooledObject' must not be null!");
        }
        this.objectPool = objectPool;
        this.object = pooledObject;
    }

    protected T _getObject() throws Exception {
        this._ensureIsValid();
        this._updateLastActiveTime();
        return this.object;
    }

    protected void _ensureIsValid() throws Exception {
        if (!this._isValid()) {
            throw new IllegalStateException("This object is no longer valid! It was either checked back into the object pool or reclaimed by it.");
        }
    }

    protected boolean _isValid() {
        return this.object != null;
    }

    protected void _invalidate() {
        this.object = null;
        this.objectPool = null;
    }

    protected void _checkIn() throws Exception {
        this._ensureIsValid();
        this.objectPool.checkIn(this);
    }

    public long _getLastActiveTime() {
        return this.lastActiveTime;
    }

    protected void _updateLastActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
    }
}

