/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool.generic;

public class CallerTrace {
    private final Thread thread;
    private final StackTraceElement[] stackTrace;
    private final long timestamp;

    public CallerTrace() {
        this(0);
    }

    public CallerTrace(Thread thread) {
        this(thread, 0);
    }

    public CallerTrace(int trimStackTrace) {
        this(Thread.currentThread(), trimStackTrace);
    }

    public CallerTrace(Thread thread, int trimStackTrace) {
        StackTraceElement[] threadStack;
        if (thread == null) {
            throw new IllegalArgumentException("The parameter 'thread' must not be null!");
        }
        this.thread = thread;
        try {
            threadStack = thread.getStackTrace();
        }
        catch (SecurityException securityException) {
            threadStack = new StackTraceElement[]{};
        }
        this.stackTrace = this.trimStackTrace(threadStack, trimStackTrace);
        this.timestamp = System.currentTimeMillis();
    }

    private StackTraceElement[] trimStackTrace(StackTraceElement[] stackTrace, int extraTrim) {
        if (extraTrim < 0) {
            throw new IllegalArgumentException("The parameter 'extraTrim' must not be negative!");
        }
        int offset = 0;
        boolean phaseOne = true;
        while (offset < stackTrace.length) {
            boolean fromThisClass = stackTrace[offset].getClassName().equals(this.getClass().getName());
            if (phaseOne) {
                if (fromThisClass) {
                    phaseOne = false;
                }
            } else if (!fromThisClass) break;
            ++offset;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - (offset += extraTrim)];
        System.arraycopy(stackTrace, offset, newStackTrace, 0, newStackTrace.length);
        return newStackTrace;
    }

    public CallerTrace(Thread thread, StackTraceElement[] stackTrace) {
        if (thread == null) {
            throw new IllegalArgumentException("The parameter 'thread' must not be null!");
        }
        if (stackTrace == null) {
            throw new IllegalArgumentException("The parameter 'stackTrace' must not be null!");
        }
        this.thread = thread;
        this.stackTrace = (StackTraceElement[])stackTrace.clone();
        this.timestamp = System.currentTimeMillis();
    }

    public Thread getThread() {
        return this.thread;
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.stackTrace.clone();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

