/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool.generic;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.objectpool.ObjectLifeCycle;
import de.aristaflow.adept2.util.objectpool.ObjectPool;
import de.aristaflow.adept2.util.objectpool.ObjectWrapperLifeCycle;
import de.aristaflow.adept2.util.objectpool.generic.CallerTrace;
import de.aristaflow.adept2.util.objectpool.generic.ObjectPoolListener;
import de.aristaflow.adept2.util.objectpool.generic.PoolConfiguration;
import de.aristaflow.adept2.util.objectpool.generic.ReclaimAction;
import de.aristaflow.adept2.util.objectpool.generic.RepeatableTask;
import de.aristaflow.adept2.util.objectpool.generic.RepeatableTaskExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GenericObjectPool<T, E extends Exception>
implements ObjectPool<T, E> {
    private State state = State.RUNNING;
    private final Map<T, Entry<T>> pooledObjects = new ConcurrentHashMap<T, Entry<T>>();
    final Queue<T> availableObjects = new ConcurrentLinkedQueue<T>();
    Semaphore availableSlots;
    ObjectLifeCycle<T, E> objectLifeCycle;
    ObjectWrapperLifeCycle<T, E> objectWrapperLifeCycle;
    private PoolConfiguration configuration;
    ObjectPoolListener<T> objectPoolListener;
    RepeatableTaskExecutor taskExecutor = new RepeatableTaskExecutor();
    private final CountDownLatch terminationLock = new CountDownLatch(1);

    public GenericObjectPool(ObjectLifeCycle<T, E> objectLifeCycle, ObjectWrapperLifeCycle<T, E> objectWrapperLifeCycle, PoolConfiguration configuration) {
        ArgChecks.checkForNull(objectLifeCycle, "objectLifeCycle");
        ArgChecks.checkForNull(configuration, "configuration");
        this.objectLifeCycle = objectLifeCycle;
        this.objectWrapperLifeCycle = objectWrapperLifeCycle;
        this.configuration = configuration.clone();
        this.availableSlots = new Semaphore(this.getConfiguration().getMaxObjectCount(), true);
        this.taskExecutor.registerTask(AvailableObjectExpirationCheckTask.class, new AvailableObjectExpirationCheckTask());
        this.taskExecutor.registerTask(LeaseExpirationCheckTask.class, new LeaseExpirationCheckTask());
        this.taskExecutor.registerTask(ShutDownTask.class, new ShutDownTask());
        this.taskExecutor.registerTask(ForceShutDownTask.class, new ForceShutDownTask());
        this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).start();
        this.taskExecutor.getTask(LeaseExpirationCheckTask.class).start();
    }

    PoolConfiguration getConfiguration() {
        return this.configuration;
    }

    public ObjectPoolListener<T> getObjectPoolListener() {
        return this.objectPoolListener;
    }

    public void setObjectPoolListener(ObjectPoolListener<T> objectPoolListener) {
        this.objectPoolListener = objectPoolListener;
    }

    boolean isWrappingEnabled() {
        return this.objectWrapperLifeCycle != null;
    }

    public int getObjectCount() {
        return this.pooledObjects.size();
    }

    public int getAvailableObjectCount() {
        return this.availableObjects.size();
    }

    public int getCheckedOutObjectCount() {
        return this.getObjectCount() - this.getAvailableObjectCount();
    }

    @Override
    public T checkOut() throws E {
        this.ensureNotShutDown();
        this.availableSlots.acquireUninterruptibly();
        this.ensureNotShutDown();
        return this._checkOut();
    }

    public T checkOutInterruptibly() throws E, InterruptedException {
        this.ensureNotShutDown();
        this.availableSlots.acquire();
        this.ensureNotShutDown();
        return this._checkOut();
    }

    public T checkOutInterruptibly(long timeout) throws E, InterruptedException {
        this.ensureNotShutDown();
        boolean slotAcquired = this.availableSlots.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        if (!slotAcquired) {
            return null;
        }
        this.ensureNotShutDown();
        return this._checkOut();
    }

    /*
     * Exception decompiling
     */
    private T _checkOut() throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private T wrapObject(T object, Entry<T> entry) {
        assert (entry.getObject() == object);
        T wrapper = this.objectWrapperLifeCycle.wrap(this, object);
        entry.setWrapper(wrapper);
        return wrapper;
    }

    @Override
    public void checkIn(T object) throws E {
        this.checkIn(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(T origObject, boolean indicateError) throws E {
        Entry<T> entry;
        T object = origObject;
        if (this.isTerminated()) {
            return;
        }
        ArgChecks.checkForNull(object, "object");
        if (this.isWrappingEnabled()) {
            if (!this.objectWrapperLifeCycle.isWrapper(object)) {
                throw new IllegalArgumentException("The given object is not a wrapper, as it was expected!");
            }
            T wrappedObject = this.objectWrapperLifeCycle.unwrap(object);
            entry = this.getEntryFor(wrappedObject);
        } else {
            entry = this.getEntryFor(object);
        }
        if (entry == null) {
            throw new IllegalArgumentException("The given object is not or no longer managed by this pool!");
        }
        Entry<T> entry2 = entry;
        synchronized (entry2) {
            if (!this.isValidEntry(entry)) {
                throw new IllegalArgumentException("The given object is not or no longer managed by this pool!");
            }
            if (entry.isAvailable()) {
                throw new IllegalArgumentException("The given object is already checked in and available!");
            }
            if (this.isWrappingEnabled()) {
                T wrapper = object;
                object = this.unwrapObject(wrapper, entry);
            }
            boolean successfullyPassivated = false;
            try {
                this.objectLifeCycle.passivate(object);
                successfullyPassivated = true;
                entry.setAvailable(true);
            }
            catch (Throwable throwable) {
                if (this.isShutdown()) {
                    this.destroyObject(object);
                    this.tryToTerminate();
                } else if (!successfullyPassivated) {
                    this.destroyObject(object);
                } else if (this.getAvailableObjectCount() >= this.getConfiguration().getMaxAvailableObjectCount()) {
                    this.destroyObject(object);
                } else if ((this.getConfiguration().getValidateOnCheckIn() || indicateError) && !this.objectLifeCycle.isValid(object)) {
                    this.destroyObject(object);
                } else {
                    boolean offered = this.availableObjects.offer(object);
                    if (!offered) {
                        String msg = String.format("The object %s could not be added to the available objects queue!", object.getClass());
                        LoggerTools.getLogger(this).severe(msg);
                    }
                    this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).start();
                }
                if (this.objectPoolListener != null) {
                    this.objectPoolListener.objectCheckedIn(entry.getObject(), entry.getCallerTrace(), new CallerTrace(1));
                }
                this.availableSlots.release();
                if (this.getCheckedOutObjectCount() == 0) {
                    this.taskExecutor.getTask(LeaseExpirationCheckTask.class).stop();
                }
                throw throwable;
            }
            if (this.isShutdown()) {
                this.destroyObject(object);
                this.tryToTerminate();
            } else if (!successfullyPassivated) {
                this.destroyObject(object);
            } else if (this.getAvailableObjectCount() >= this.getConfiguration().getMaxAvailableObjectCount()) {
                this.destroyObject(object);
            } else if ((this.getConfiguration().getValidateOnCheckIn() || indicateError) && !this.objectLifeCycle.isValid(object)) {
                this.destroyObject(object);
            } else {
                boolean offered = this.availableObjects.offer(object);
                if (!offered) {
                    String msg = String.format("The object %s could not be added to the available objects queue!", object.getClass());
                    LoggerTools.getLogger(this).severe(msg);
                }
                this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).start();
            }
            if (this.objectPoolListener != null) {
                this.objectPoolListener.objectCheckedIn(entry.getObject(), entry.getCallerTrace(), new CallerTrace(1));
            }
            this.availableSlots.release();
            if (this.getCheckedOutObjectCount() == 0) {
                this.taskExecutor.getTask(LeaseExpirationCheckTask.class).stop();
            }
        }
    }

    private T unwrapObject(T wrapper, Entry<T> entry) {
        T object = this.objectWrapperLifeCycle.unwrap(wrapper);
        assert (entry.getObject() == object);
        this.objectWrapperLifeCycle.invalidate(wrapper);
        if (wrapper != entry.getWrapper()) {
            throw new IllegalStateException("The object was checked in with a different wrapper than in it was checked out with!");
        }
        entry.setWrapper(null);
        return object;
    }

    private Entry<T> createObject() throws E {
        T object = this.objectLifeCycle.create();
        Entry<T> entry = new Entry<T>(object);
        this.pooledObjects.put(object, entry);
        if (this.objectPoolListener != null) {
            this.objectPoolListener.objectCreated(object, this.getObjectCount());
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyObject(T object) {
        Entry<T> entry = this.removeObject(object);
        if (entry == null) {
            return;
        }
        Entry<T> entry2 = entry;
        synchronized (entry2) {
            block7: {
                try {
                    this.objectLifeCycle.destroy(object);
                    if (this.objectPoolListener != null) {
                        this.objectPoolListener.objectDestroyed(object, this.getObjectCount(), null);
                    }
                }
                catch (Exception ex) {
                    if (this.objectPoolListener == null) break block7;
                    this.objectPoolListener.objectDestroyed(object, this.getObjectCount(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry<T> removeObject(T object) {
        Entry<T> entry = this.pooledObjects.remove(object);
        if (entry == null) {
            return null;
        }
        Entry<T> entry2 = entry;
        synchronized (entry2) {
            if (entry.isAvailable()) {
                this.availableObjects.remove(object);
                if (this.getAvailableObjectCount() == 0) {
                    this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).stop();
                }
            }
            return entry;
        }
    }

    Entry<T> getEntryFor(T object) {
        return this.pooledObjects.get(object);
    }

    Collection<Entry<T>> getAllEntries() {
        return this.pooledObjects.values();
    }

    boolean isValidEntry(Entry<T> entry) {
        return this.pooledObjects.containsKey(entry.getObject());
    }

    public void awaitTermination() throws InterruptedException {
        this.terminationLock.await();
    }

    public boolean awaitTermination(long timeout) throws InterruptedException {
        this.terminationLock.await(timeout, TimeUnit.MILLISECONDS);
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.state == State.SHUTDOWN || this.state == State.FORCED_SHUTDOWN || this.state == State.TERMINATED;
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this.isShutdown()) {
                return;
            }
            this.state = State.SHUTDOWN;
        }
        this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).stop();
        this.taskExecutor.getTask(ShutDownTask.class).start();
    }

    @Override
    public void forceShutdown() {
        this.forceShutdown(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceShutdown(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("The parameter 'delay' must not be negative!");
        }
        this.shutdown();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this.isTerminated()) {
                return;
            }
            this.state = State.FORCED_SHUTDOWN;
        }
        this.taskExecutor.getTask(ForceShutDownTask.class).setNextRun(delay + 1L);
    }

    void destroyAvailableObjects() {
        for (Object object : this.availableObjects) {
            this.destroyObject(object);
        }
    }

    void destroyCheckedOutObjects() {
        for (T object : this.pooledObjects.keySet()) {
            this.destroyObject(object);
        }
    }

    void tryToTerminate() {
        if (this.getObjectCount() == 0) {
            this.state = State.TERMINATED;
            this.taskExecutor.shutdown();
            this.terminationLock.countDown();
        }
    }

    private void ensureNotShutDown() {
        if (this.isShutdown()) {
            throw new IllegalStateException("This object pool is already shut(ting) down!");
        }
    }

    private void ensureNotTerminated() {
        if (this.isTerminated()) {
            throw new IllegalStateException("This object pool is already terminated!");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    void printPooledObjects() {
        System.out.println("pooled objects:");
        for (T object : this.pooledObjects.keySet()) {
            System.out.println("  " + object);
        }
    }

    void printAvailableObjects() {
        System.out.println("available objects:");
        for (Object object : this.availableObjects) {
            System.out.println("  " + object);
        }
    }

    private class AvailableObjectExpirationCheckTask
    extends RepeatableTask {
        public AvailableObjectExpirationCheckTask() {
            super(GenericObjectPool.this.taskExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run() {
            if (GenericObjectPool.this.getConfiguration().getAvailableObjectExpirationPeriod() > -1) {
                for (Object object : GenericObjectPool.this.availableObjects) {
                    Entry entry = GenericObjectPool.this.getEntryFor(object);
                    if (entry == null) continue;
                    Entry entry2 = entry;
                    synchronized (entry2) {
                        if (!GenericObjectPool.this.isValidEntry(entry) || !entry.isAvailable()) {
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        if (entry.getAvailableSince() + (long)GenericObjectPool.this.getConfiguration().getAvailableObjectExpirationPeriod() <= now) {
                            boolean stillAvailable = GenericObjectPool.this.availableObjects.remove(object);
                            if (GenericObjectPool.this.getAvailableObjectCount() == 0) {
                                GenericObjectPool.this.taskExecutor.getTask(AvailableObjectExpirationCheckTask.class).stop();
                            }
                            if (stillAvailable) {
                                GenericObjectPool.this.destroyObject(object);
                            }
                        } else {
                            break;
                        }
                    }
                }
            }
        }

        @Override
        protected long getRepeatingRunDelay() {
            if (GenericObjectPool.this.getConfiguration().getAvailableObjectExpirationPeriod() > -1) {
                return GenericObjectPool.this.getConfiguration().getAvailableObjectExpirationCheckPeriod();
            }
            return -1L;
        }
    }

    static class Entry<T> {
        private T object;
        private T wrapper;
        private boolean isAvailable = true;
        private long availableSince = -1L;
        private long checkedOutSince = -1L;
        private CallerTrace callerTrace;

        protected Entry(T object) {
            ArgChecks.checkForNull(object, "object");
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }

        void setWrapper(T wrapper) {
            this.wrapper = wrapper;
        }

        public T getWrapper() {
            return this.wrapper;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        void setAvailable(boolean available) {
            this.isAvailable = available;
            if (!available) {
                this.setAvailableSince(-1L);
                this.setCheckedOutSince(System.currentTimeMillis());
            } else {
                this.setAvailableSince(System.currentTimeMillis());
                this.setCheckedOutSince(-1L);
            }
        }

        public boolean isCheckedOut() {
            return !this.isAvailable;
        }

        public long getAvailableSince() {
            return this.availableSince;
        }

        void setAvailableSince(long availableSince) {
            this.availableSince = availableSince;
        }

        public long getCheckedOutSince() {
            return this.checkedOutSince;
        }

        void setCheckedOutSince(long checkedOutSince) {
            this.checkedOutSince = checkedOutSince;
        }

        public CallerTrace getCallerTrace() {
            return this.callerTrace;
        }

        public void setCallerTrace(CallerTrace callerTrace) {
            this.callerTrace = callerTrace;
        }
    }

    private class ForceShutDownTask
    extends RepeatableTask {
        public ForceShutDownTask() {
            super(GenericObjectPool.this.taskExecutor);
        }

        @Override
        protected void run() {
            GenericObjectPool.this.destroyCheckedOutObjects();
            GenericObjectPool.this.tryToTerminate();
        }

        @Override
        protected long getRepeatingRunDelay() {
            return -1L;
        }
    }

    private class LeaseExpirationCheckTask
    extends RepeatableTask {
        public LeaseExpirationCheckTask() {
            super(GenericObjectPool.this.taskExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run() {
            Iterator iterator = GenericObjectPool.this.getAllEntries().iterator();
            while (iterator.hasNext()) {
                Entry entry;
                Entry entry2 = entry = iterator.next();
                synchronized (entry2) {
                    boolean reclaim;
                    long lastActiveTime;
                    if (!GenericObjectPool.this.isValidEntry(entry) || !entry.isCheckedOut()) {
                        continue;
                    }
                    boolean isAbandoned = false;
                    if (GenericObjectPool.this.getConfiguration().getAbandonedObjectTimeout() > -1 && (lastActiveTime = GenericObjectPool.this.isWrappingEnabled() ? GenericObjectPool.this.objectWrapperLifeCycle.getLastActiveTime(entry.getWrapper()) : GenericObjectPool.this.objectLifeCycle.getLastActiveTime(entry.getObject())) > -1L) {
                        isAbandoned = lastActiveTime + (long)GenericObjectPool.this.getConfiguration().getAbandonedObjectTimeout() < System.currentTimeMillis();
                    }
                    boolean isLeaseExpired = false;
                    if (GenericObjectPool.this.getConfiguration().getMaxLeasePeriod() > -1) {
                        long leaseExpirationTime = entry.getCheckedOutSince() + (long)GenericObjectPool.this.getConfiguration().getMaxLeasePeriod();
                        boolean bl = isLeaseExpired = leaseExpirationTime <= System.currentTimeMillis();
                    }
                    if (GenericObjectPool.this.getConfiguration().getOnlyReclaimWhenAbandonedAndExpired()) {
                        reclaim = !(!isAbandoned && GenericObjectPool.this.getConfiguration().getAbandonedObjectTimeout() > -1 || !isLeaseExpired && GenericObjectPool.this.getConfiguration().getMaxLeasePeriod() > -1);
                    } else {
                        boolean bl = reclaim = isAbandoned || isLeaseExpired;
                    }
                    if (reclaim) {
                        ReclaimAction reclaimAction = GenericObjectPool.this.getConfiguration().getReclaimAction();
                        if (reclaimAction == ReclaimAction.RECLAIM_OR_DESTROY_OBJECT) {
                            reclaimAction = GenericObjectPool.this.isWrappingEnabled() ? ReclaimAction.RECLAIM_OBJECT : ReclaimAction.DESTROY_OBJECT;
                        }
                        switch (reclaimAction) {
                            case RECLAIM_OBJECT: {
                                try {
                                    if (GenericObjectPool.this.isWrappingEnabled()) {
                                        GenericObjectPool.this.checkIn(entry.getWrapper());
                                    } else {
                                        GenericObjectPool.this.checkIn(entry.getObject());
                                    }
                                }
                                catch (Exception exception) {}
                                GenericObjectPool.this.availableSlots.release();
                                break;
                            }
                            case DESTROY_OBJECT: {
                                if (GenericObjectPool.this.isWrappingEnabled()) {
                                    GenericObjectPool.this.objectWrapperLifeCycle.invalidate(entry.getWrapper());
                                }
                                GenericObjectPool.this.destroyObject(entry.getObject());
                                if (GenericObjectPool.this.isShutdown()) {
                                    GenericObjectPool.this.tryToTerminate();
                                }
                                GenericObjectPool.this.availableSlots.release();
                                break;
                            }
                            case RELEASE_OBJECT: {
                                GenericObjectPool.this.removeObject(entry.getObject());
                                if (GenericObjectPool.this.isShutdown()) {
                                    GenericObjectPool.this.tryToTerminate();
                                }
                                GenericObjectPool.this.availableSlots.release();
                                break;
                            }
                            case NO_ACTION: {
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)((Object)((Object)reclaimAction) + " not yet implemented!"));
                            }
                        }
                        if (GenericObjectPool.this.objectPoolListener != null) {
                            GenericObjectPool.this.objectPoolListener.objectReclaimed(entry.getObject(), reclaimAction, entry.getCallerTrace());
                        }
                    }
                }
            }
        }

        @Override
        protected long getRepeatingRunDelay() {
            return GenericObjectPool.this.getConfiguration().getLeaseCheckPeriod();
        }
    }

    private class ShutDownTask
    extends RepeatableTask {
        public ShutDownTask() {
            super(GenericObjectPool.this.taskExecutor);
        }

        @Override
        protected void run() {
            GenericObjectPool.this.destroyAvailableObjects();
            GenericObjectPool.this.tryToTerminate();
        }

        @Override
        protected long getInitialRunDelay() {
            return 0L;
        }

        @Override
        protected long getRepeatingRunDelay() {
            return -1L;
        }
    }

    private static enum State {
        RUNNING,
        SHUTDOWN,
        FORCED_SHUTDOWN,
        TERMINATED;

    }
}

