/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool.generic;

import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.objectpool.generic.ReclaimAction;

public final class PoolConfiguration
implements Cloneable {
    private int maxObjectCount = Integer.MAX_VALUE;
    private int maxAvailableObjectCount = Integer.MAX_VALUE;
    private boolean validateOnCheckOut = true;
    private boolean validateOnCheckIn = true;
    private int availableObjectExpirationPeriod = 60000;
    private int availableObjectExpirationCheckPeriod = 10000;
    private int maxLeasePeriod = 200000;
    private int leaseCheckPeriod = 5000;
    private int abandonedObjectTimeout = 300000;
    private boolean onlyReclaimWhenAbandonedAndExpired = true;
    private ReclaimAction reclaimAction = ReclaimAction.RECLAIM_OR_DESTROY_OBJECT;
    private boolean keepCallerTrace = true;

    public int getMaxObjectCount() {
        return this.maxObjectCount;
    }

    public void setMaxObjectCount(int maxObjectCount) {
        this.maxObjectCount = maxObjectCount;
    }

    public int getMaxAvailableObjectCount() {
        return this.maxAvailableObjectCount;
    }

    public void setMaxAvailableObjectCount(int maxAvailableObjectCount) {
        this.maxAvailableObjectCount = maxAvailableObjectCount;
    }

    public int getAvailableObjectExpirationPeriod() {
        return this.availableObjectExpirationPeriod;
    }

    public void setAvailableObjectExpirationPeriod(int availableObjectExpirationPeriod) {
        this.availableObjectExpirationPeriod = availableObjectExpirationPeriod;
    }

    public int getAvailableObjectExpirationCheckPeriod() {
        return this.availableObjectExpirationCheckPeriod;
    }

    public void setAvailableObjectExpirationCheckPeriod(int availableObjectExpirationCheckPeriod) {
        this.availableObjectExpirationCheckPeriod = availableObjectExpirationCheckPeriod;
    }

    public boolean getValidateOnCheckOut() {
        return this.validateOnCheckOut;
    }

    public void setValidateOnCheckOut(boolean validateOnCheckOut) {
        this.validateOnCheckOut = validateOnCheckOut;
    }

    public boolean getValidateOnCheckIn() {
        return this.validateOnCheckIn;
    }

    public void setValidateOnCheckIn(boolean validateOnCheckIn) {
        this.validateOnCheckIn = validateOnCheckIn;
    }

    public int getLeaseCheckPeriod() {
        return this.leaseCheckPeriod;
    }

    public void setLeaseCheckPeriod(int leaseDurationCheckPeriod) {
        this.leaseCheckPeriod = leaseDurationCheckPeriod;
    }

    public ReclaimAction getReclaimAction() {
        return this.reclaimAction;
    }

    public void setReclaimAction(ReclaimAction reclaimAction) {
        if (reclaimAction == null) {
            throw new NullArgumentException("The parameter 'reclaimAction' must not be null!");
        }
        this.reclaimAction = reclaimAction;
    }

    public int getMaxLeasePeriod() {
        return this.maxLeasePeriod;
    }

    public void setMaxLeasePeriod(int maxLeasePeriod) {
        this.maxLeasePeriod = maxLeasePeriod;
    }

    public int getAbandonedObjectTimeout() {
        return this.abandonedObjectTimeout;
    }

    public void setAbandonedObjectTimeout(int abandonedObjectTimeout) {
        this.abandonedObjectTimeout = abandonedObjectTimeout;
    }

    public boolean getOnlyReclaimWhenAbandonedAndExpired() {
        return this.onlyReclaimWhenAbandonedAndExpired;
    }

    public void setOnlyReclaimWhenAbandonedAndExpired(boolean onlyReclaimWhenAbandonedAndExpired) {
        this.onlyReclaimWhenAbandonedAndExpired = onlyReclaimWhenAbandonedAndExpired;
    }

    public boolean getKeepCallerTrace() {
        return this.keepCallerTrace;
    }

    public void setKeepCallerTrace(boolean keepCallerTrace) {
        this.keepCallerTrace = keepCallerTrace;
    }

    protected PoolConfiguration clone() {
        try {
            return (PoolConfiguration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

