/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool.generic;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.objectpool.generic.RepeatableTaskExecutor;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

abstract class RepeatableTask
implements Delayed {
    private RepeatableTaskExecutor taskExecutor;
    private long nextRun = -1L;

    protected RepeatableTask(RepeatableTaskExecutor taskExecutor) {
        ArgChecks.checkForNull(taskExecutor, "taskExecutor");
        this.taskExecutor = taskExecutor;
    }

    RepeatableTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    void start() {
        if (this.nextRun < 0L) {
            this.setNextRun(this.getInitialRunDelay());
        }
    }

    void restart() {
        this.setNextRun(this.getInitialRunDelay());
    }

    void stop() {
        this.setNextRun(-1L);
    }

    void internalRun() {
        try {
            this.run();
        }
        finally {
            if (this.nextRun > -1L) {
                this.setNextRun(this.getRepeatingRunDelay());
            }
        }
    }

    void setNextRun(long delay) {
        if (delay >= 0L) {
            this.nextRun = System.currentTimeMillis() + delay;
            this.getTaskExecutor().queueTask(this);
        } else {
            this.nextRun = -1L;
            this.getTaskExecutor().cancelTask(this);
        }
    }

    void setNextRun() {
        this.setNextRun(this.getRepeatingRunDelay());
    }

    protected abstract void run();

    protected long getInitialRunDelay() {
        return this.getRepeatingRunDelay();
    }

    protected abstract long getRepeatingRunDelay();

    @Override
    public final long getDelay(TimeUnit unit) {
        return unit.convert(this.nextRun - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed o) {
        long difference = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (difference > 0L) {
            return 1;
        }
        if (difference < 0L) {
            return -1;
        }
        return 0;
    }
}

