/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.objectpool.generic;

import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.objectpool.generic.RepeatableTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;

class RepeatableTaskExecutor {
    private List<Worker> workers = new ArrayList<Worker>();
    private final Map<Class<? extends RepeatableTask>, RepeatableTask> tasks = new HashMap<Class<? extends RepeatableTask>, RepeatableTask>();
    DelayQueue<RepeatableTask> activeTasks = new DelayQueue();

    public RepeatableTaskExecutor() {
        this.addWorker();
    }

    private void addWorker() {
        Worker worker = new Worker();
        this.workers.add(worker);
        Thread thread = new Thread((Runnable)worker, "RepeatableTaskExecutor#addWorker()");
        thread.start();
    }

    public <D extends RepeatableTask> void registerTask(Class<D> cls, D task) {
        this.tasks.put(cls, task);
    }

    public RepeatableTask getTask(Class<? extends RepeatableTask> cls) {
        RepeatableTask task = this.tasks.get(cls);
        if (task == null) {
            throw new IllegalArgumentException("task not registered: " + cls);
        }
        return task;
    }

    public RepeatableTask[] getTasks() {
        return this.tasks.keySet().toArray(new RepeatableTask[this.tasks.size()]);
    }

    public int getActiveTaskCount() {
        return this.activeTasks.size();
    }

    void cancelTask(RepeatableTask task) {
        int i = 0;
        while (i < 10) {
            try {
                this.activeTasks.removeAll(Collections.singleton(task));
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        throw new RuntimeException("could not cancel task");
    }

    void queueTask(RepeatableTask task) {
        this.cancelTask(task);
        this.activeTasks.put(task);
    }

    public void shutdown() {
        for (Worker worker : this.workers) {
            worker.shutdown();
        }
    }

    class Worker
    implements Runnable {
        private static final String VM_ERROR_OUTPUT = "VirtualMachineError in RepeatableTaskExecutor, trying to continue.";
        private volatile boolean shutdown = false;
        private Thread runningThread;

        Worker() {
        }

        @Override
        public void run() {
            this.runningThread = Thread.currentThread();
            while (!this.shutdown) {
                try {
                    RepeatableTask task = (RepeatableTask)RepeatableTaskExecutor.this.activeTasks.take();
                    task.internalRun();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.shutdown) continue;
                    return;
                }
                catch (RuntimeException re) {
                    LoggerTools.logUnhandledException(re);
                }
                catch (VirtualMachineError er) {
                    LoggerTools.logVirtualMachineErrorSafely(er, VM_ERROR_OUTPUT);
                }
            }
        }

        void shutdown() {
            this.shutdown = true;
            if (this.runningThread != null) {
                this.runningThread.interrupt();
            }
        }
    }
}

