/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.shell;

public class TypeConverter {
    public static Object getStronglyTypedValue(String s) {
        if (s.length() == 0 || s.length() == 1 && s.charAt(0) == '\"') {
            throw new ClassCastException("Received an empty string or a single \"");
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s;
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        if (s.length() >= 2) {
            String number = s.substring(0, s.length() - 1);
            switch (s.charAt(s.length() - 1)) {
                case 'i': {
                    if (!TypeConverter.isInt(number)) break;
                    return Integer.valueOf(number);
                }
                case 'b': {
                    if (!TypeConverter.isByte(number)) break;
                    return Byte.valueOf(number);
                }
                case 'l': {
                    if (!TypeConverter.isLong(number)) break;
                    return Long.valueOf(number);
                }
                case 'f': {
                    if (!TypeConverter.isFloat(number)) break;
                    return Float.valueOf(number);
                }
                case 'd': {
                    if (!TypeConverter.isDouble(number)) break;
                    return Double.valueOf(number);
                }
                case 's': {
                    if (!TypeConverter.isShort(number)) break;
                    return Short.valueOf(number);
                }
            }
        }
        throw new ClassCastException("Not strongly typed.");
    }

    public static Class<?> getStrongTyping(String s) {
        if (s.length() == 0 || s.length() == 1 && s.charAt(0) == '\"') {
            throw new ClassCastException("Received empty string");
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return String.class;
        }
        if (s.equals("true") || s.equals("false")) {
            return Boolean.TYPE;
        }
        if (s.length() >= 2) {
            String number = s.substring(0, s.length() - 1);
            switch (s.charAt(s.length() - 1)) {
                case 'i': {
                    if (!TypeConverter.isInt(number)) break;
                    return Integer.TYPE;
                }
                case 'b': {
                    if (!TypeConverter.isByte(number)) break;
                    return Byte.TYPE;
                }
                case 'l': {
                    if (!TypeConverter.isLong(number)) break;
                    return Long.TYPE;
                }
                case 'f': {
                    if (!TypeConverter.isFloat(number)) break;
                    return Float.TYPE;
                }
                case 'd': {
                    if (!TypeConverter.isDouble(number)) break;
                    return Double.TYPE;
                }
                case 's': {
                    if (!TypeConverter.isShort(number)) break;
                    return Short.TYPE;
                }
            }
        }
        throw new ClassCastException("No strong typing discovered.");
    }

    public static Class<?> getGuessedNumberType(String number) {
        if (number.length() == 0) {
            throw new NumberFormatException("Received an empty string.");
        }
        if (TypeConverter.isByte(number)) {
            return Byte.TYPE;
        }
        if (TypeConverter.isShort(number)) {
            return Short.TYPE;
        }
        if (TypeConverter.isInt(number)) {
            return Integer.TYPE;
        }
        if (TypeConverter.isLong(number)) {
            return Long.TYPE;
        }
        if (TypeConverter.isFloat(number)) {
            return Float.TYPE;
        }
        if (TypeConverter.isDouble(number)) {
            return Double.TYPE;
        }
        throw new NumberFormatException("Not a number type.");
    }

    public static Object getGuessedNumberValue(String number) {
        if (number.length() == 0) {
            throw new NumberFormatException("Received an empty string.");
        }
        if (TypeConverter.isByte(number)) {
            return Byte.valueOf(number);
        }
        if (TypeConverter.isShort(number)) {
            return Short.valueOf(number);
        }
        if (TypeConverter.isInt(number)) {
            return Integer.valueOf(number);
        }
        if (TypeConverter.isLong(number)) {
            return Long.valueOf(number);
        }
        if (TypeConverter.isFloat(number)) {
            return Float.valueOf(number);
        }
        if (TypeConverter.isDouble(number)) {
            return Double.valueOf(number);
        }
        throw new NumberFormatException("Not a number type.");
    }

    public static boolean isCompatibleType(Class<?> type, Class<?> compatible) {
        if (!(type != Boolean.TYPE && type != Boolean.class || compatible != Boolean.TYPE && compatible != Boolean.class)) {
            return true;
        }
        if (!(type != Long.TYPE && type != Long.class || compatible != Long.class && compatible != Long.TYPE && compatible != Integer.TYPE && compatible != Integer.class && compatible != Short.TYPE && compatible != Short.class && compatible != Byte.TYPE && compatible != Byte.class)) {
            return true;
        }
        if (!(type != Integer.TYPE && type != Integer.class || compatible != Integer.class && compatible != Integer.TYPE && compatible != Short.TYPE && compatible != Short.class && compatible != Byte.TYPE && compatible != Byte.class)) {
            return true;
        }
        if (!(type != Short.TYPE && type != Short.class || compatible != Short.TYPE && compatible != Short.class && compatible != Byte.TYPE && compatible != Byte.class)) {
            return true;
        }
        if (!(type != Float.TYPE && type != Float.class || compatible != Float.TYPE && compatible != Float.class && compatible != Integer.class && compatible != Integer.TYPE && compatible != Short.TYPE && compatible != Short.class && compatible != Byte.TYPE && compatible != Byte.class)) {
            return true;
        }
        return !(type != Double.TYPE && type != Double.class || type != Double.TYPE && type != Double.class && compatible != Long.class && compatible != Long.TYPE && compatible != Float.TYPE && compatible != Float.class && compatible != Integer.class && compatible != Integer.TYPE && compatible != Short.TYPE && compatible != Short.class && compatible != Byte.TYPE && compatible != Byte.class);
    }

    public static boolean isInt(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isLong(String number) {
        try {
            Long.parseLong(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isByte(String number) {
        try {
            Byte.parseByte(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isChar(String number) {
        return number.length() == 1;
    }

    public static boolean isDouble(String number) {
        try {
            Double.parseDouble(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isFloat(String number) {
        try {
            Float.parseFloat(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isShort(String number) {
        try {
            Short.parseShort(number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Class<?> getObjectClassForSimpleClass(Class<?> simple) {
        if (simple == Integer.TYPE) {
            return Integer.class;
        }
        if (simple == Short.TYPE) {
            return Short.class;
        }
        if (simple == Long.TYPE) {
            return Long.class;
        }
        if (simple == Byte.TYPE) {
            return Byte.class;
        }
        if (simple == Character.TYPE) {
            return Character.class;
        }
        if (simple == Double.TYPE) {
            return Double.class;
        }
        if (simple == Float.TYPE) {
            return Float.class;
        }
        throw new IllegalArgumentException("Unknown simple type: " + simple.getSimpleName());
    }
}

