/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.shell.commands;

import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommand;
import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommandSet;
import java.util.HashMap;
import java.util.Map;

public class HashMapCommands
extends AbstractCommandSet {
    public HashMapCommands() {
        this.addCommand(new HashMapGetCommand());
        this.addCommand(new HashMapPutCommand());
        this.addCommand(new CreateHashMapCommand());
        this.addCommand(new CreateHashMapCommand());
    }

    protected static class CreateHashMapCommand
    extends AbstractCommand {
        public CreateHashMapCommand() {
            super("hashMap", "Create a new HashMap object");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            return new HashMap();
        }
    }

    protected static class HashMapGetCommand
    extends AbstractCommand {
        public HashMapGetCommand() {
            super("hashMapGet", "Get a value from a HashMap");
            this.parameters = new Class[]{Map.class, Object.class};
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            Map map = (Map)parameters[0];
            return map.get(parameters[1]);
        }
    }

    protected static class HashMapPutCommand
    extends AbstractCommand {
        public HashMapPutCommand() {
            super("hashMapPut", "Put a key / value pair in a HashMap");
            this.parameters = new Class[]{Map.class, Object.class, Object.class};
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            Map map = (Map)parameters[0];
            map.put(parameters[1], parameters[2]);
            return null;
        }
    }

    protected static class HashMapRemoveCommand
    extends AbstractCommand {
        public HashMapRemoveCommand() {
            super("hashMapRemove", "Remove a value from a HashMap");
            this.parameters = new Class[]{Map.class, Object.class};
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            Map map = (Map)parameters[0];
            return map.remove(parameters[1]);
        }
    }
}

