/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.shell.defaultimplementation;

import de.aristaflow.adept2.util.shell.Command;
import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommandRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCommand
extends AbstractCommandRunner
implements Command {
    protected String name;
    protected String description = "";
    protected Class<?>[] parameters = new Class[0];
    protected Class<?> returnType;
    protected Set<Character> options = new HashSet<Character>();
    protected Map<Character, String> longOptions = new HashMap<Character, String>();
    protected Map<Character, Class<?>> optionTypes = new HashMap();
    protected String helpText = null;

    public AbstractCommand(String name, String description) {
        this.name = name;
        this.commandNames.add(name);
        this.description = description;
        this.returnType = Void.class;
    }

    protected AbstractCommand(String name, String description, Class<?>[] parameters, Class<?> returnType, Set<Character> options, Map<Character, String> longOptions, Map<Character, Class<?>> optionTypes) {
        this(name, description);
        this.parameters = parameters;
        this.returnType = returnType;
        this.options = options;
        this.longOptions = longOptions;
        this.optionTypes = optionTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?>[] getParameters() {
        Class[] ret = null;
        if (this.parameters != null) {
            ret = (Class[])this.parameters.clone();
        }
        return ret;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Set<Character> getOptions() {
        return this.options;
    }

    @Override
    public Map<Character, String> getLongOptions() {
        return this.longOptions;
    }

    @Override
    public Map<Character, Class<?>> getOptionTypes() {
        return this.optionTypes;
    }

    @Override
    public Object runCommand(String name, Map<Character, Object> options, Object[] parameters) {
        return this.runCommand(options, parameters);
    }

    @Override
    public String getHelpText() {
        if (this.helpText == null) {
            return this.generateHelp();
        }
        return this.helpText;
    }

    @Override
    public String getHelpText(String param) {
        return this.getHelpText();
    }

    @Override
    public String getDescription(String commandName) {
        return this.getDescription();
    }

    private String generateHelp() {
        StringBuilder gh = new StringBuilder("  Help for " + this.getName() + ": \n");
        gh.append("  " + this.getDescription() + "\n");
        gh.append("  Syntax:\n");
        gh.append("    ");
        gh.append(this.getName());
        Class<?>[] classArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            gh.append(" [" + c.getSimpleName() + "]");
            ++n2;
        }
        return gh.toString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public abstract Object runCommand(Map<Character, Object> var1, Object[] var2);
}

