/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.shell.defaultimplementation;

import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.shell.Command;
import de.aristaflow.adept2.util.shell.CommandNotFoundException;
import de.aristaflow.adept2.util.shell.CommandSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractCommandSet
implements CommandSet {
    protected final Logger logger;
    protected Map<String, Command> commands = new HashMap<String, Command>();

    protected AbstractCommandSet() {
        this.logger = LoggerTools.getLogger(this);
    }

    @Override
    public Map<String, Command> getCommands() {
        return this.commands;
    }

    @Override
    public Set<String> getCommandNames() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    @Override
    public Command getCommand(String name, Map<Character, Object> options, Object ... parameters) {
        for (Command command : this.getCommands().values()) {
            if (!AbstractCommandSet.commandSignatureEquals(command, name, options, parameters)) continue;
            return command;
        }
        String message = "Command '" + name + "' could not be found.";
        this.logger.info(message);
        throw new CommandNotFoundException(name, options, parameters, message);
    }

    @Deprecated
    public static boolean commandSignatureEquals(Command command, String name, Map<Character, Object> options, Object ... parameters) {
        return command.getName().equals(name);
    }

    @Override
    public Object runCommand(String name, Map<Character, Object> options, Object[] parameters) throws Exception {
        Command command = this.getCommand(name, options, parameters);
        return command.runCommand(name, options, parameters);
    }

    @Override
    public String getHelpText(String commandName) {
        Map<String, Command> myCommands = this.getCommands();
        if (myCommands.containsKey(commandName)) {
            return myCommands.get(commandName).getHelpText();
        }
        return "error: unknown command '" + commandName + "'";
    }

    @Override
    public String getDescription(String commandName) {
        Map<String, Command> myCommands = this.getCommands();
        if (myCommands.containsKey(commandName)) {
            return myCommands.get(commandName).getDescription();
        }
        return "error: unknown command '" + commandName + "'";
    }

    protected void addCommand(Command c) {
        this.commands.put(c.getName(), c);
    }
}

