/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.shell.defaultimplementation;

import de.aristaflow.adept2.util.shell.CommandNotFoundException;
import de.aristaflow.adept2.util.shell.ShellConstants;
import de.aristaflow.adept2.util.shell.TypeConverter;
import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommandRunner;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class ReflectionRunner
extends AbstractCommandRunner {
    private final Object object;
    private final Class<?> clazz;
    private final Map<String, Set<java.lang.reflect.Method>> methods = new HashMap<String, Set<java.lang.reflect.Method>>();

    public ReflectionRunner(Object object) {
        this(object, null);
    }

    public ReflectionRunner(Class<?> clazz) {
        this(null, clazz);
    }

    public ReflectionRunner(Object object, Class<?> clazz) {
        java.lang.reflect.Method[] objectMethods;
        if (object == null && clazz == null) {
            throw new IllegalArgumentException("Either an object or a class is required.");
        }
        this.object = object;
        this.clazz = clazz;
        String[] shellMethods = new String[]{};
        Class<?> logMessageClass = object != null ? object.getClass() : clazz;
        try {
            Field field = object != null ? object.getClass().getField("shellMethods") : clazz.getField("shellMethods");
            shellMethods = (String[])field.get(object);
        }
        catch (ClassCastException classCastException) {
            this.logger.warning("shellMethods-Field on '" + logMessageClass + "' must have type String[].");
        }
        catch (SecurityException securityException) {
            this.logger.info("Not allowed to read shellMethods-Field on '" + logMessageClass + "'.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.logger.finest("shellMethods-Field on '" + logMessageClass + "' not found.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.warning("Not allowed to read shellMethods-Field on '" + logMessageClass + "'.");
        }
        if (clazz == null) {
            assert (object != null);
            objectMethods = object.getClass().getMethods();
        } else {
            objectMethods = clazz.getMethods();
        }
        java.lang.reflect.Method[] methodArray = objectMethods;
        int n = objectMethods.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                String methodName;
                java.lang.reflect.Method method;
                block20: {
                    method = methodArray[n2];
                    methodName = method.getName();
                    if (shellMethods.length <= 0) break block20;
                    boolean methodOK = false;
                    String[] stringArray = shellMethods;
                    int n3 = shellMethods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String fName = stringArray[n4];
                        if (fName.equals(methodName)) {
                            methodOK = true;
                        }
                        ++n4;
                    }
                    if (!methodOK) break block21;
                }
                if (!ShellConstants.blacklistedReflectionMethods.contains(methodName)) {
                    if (!this.methods.containsKey(methodName)) {
                        this.methods.put(methodName, new HashSet());
                    } else if (this.methods.get(methodName).size() == 1) {
                        this.logger.warning("Overloaded method found ('" + methodName + "') - overloading not (fully) supported!");
                    }
                    this.commandNames.add(methodName);
                    this.methods.get(methodName).add(method);
                    this.logger.finest("Added method '" + methodName + "'.");
                }
            }
            ++n2;
        }
    }

    @Override
    public Object runCommand(String name, Map<Character, Object> options, Object[] parameters) throws Exception {
        Object result;
        block6: {
            if (!this.methods.containsKey(name)) {
                throw new CommandNotFoundException(name, "Unknown method.");
            }
            Class[] parameterTypes = ReflectionRunner.getParameterTypesForObjects(parameters);
            java.lang.reflect.Method methodToCall = this.getMethodToCall(name, parameterTypes, parameters);
            if (methodToCall == null) {
                throw new CommandNotFoundException(name, "Parameters didn't match.");
            }
            result = null;
            try {
                result = methodToCall.invoke(this.object, parameters);
            }
            catch (IllegalArgumentException e) {
                this.logger.severe("IllegalArgumentException" + e);
            }
            catch (IllegalAccessException e) {
                this.logger.severe("Tried to call a protected / private method ('" + name + "')! " + e);
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() == null || !(e.getCause() instanceof Exception)) break block6;
                throw (Exception)e.getCause();
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected java.lang.reflect.Method getMethodToCall(String name, Class[] parameterTypes, Object[] parameters) {
        methodTocall = null;
        try {
            methodTocall = this.object != null ? this.object.getClass().getMethod(name, parameterTypes) : this.clazz.getMethod(name, parameterTypes);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException v0) {}
        if (!this.methods.containsKey(name)) {
            className = this.object != null ? this.object.getClass().getSimpleName() : this.clazz.getSimpleName();
            throw new CommandNotFoundException(name, "unknown method '" + name + "' in " + className);
        }
        for (java.lang.reflect.Method method : this.methods.get(name)) {
            methodMayFit = true;
            myParameterTypes = method.getParameterTypes();
            if (parameterTypes.length != myParameterTypes.length) {
                this.logger.info("Failed on " + method.getName() + "(expected " + myParameterTypes.length + " parameters, got " + parameters.length + ")");
                continue;
            }
            i = 0;
            while (i < parameterTypes.length) {
                block28: {
                    if (!methodMayFit) break;
                    if (myParameterTypes[i] == parameterTypes[i] || TypeConverter.isCompatibleType(myParameterTypes[i], parameterTypes[i]) || parameters[i] == null) break block28;
                    if (parameterTypes[i] != String.class) ** GOTO lbl-1000
                    number = (String)parameters[i];
                    guessedNumberType = null;
                    try {
                        guessedNumberType = TypeConverter.getGuessedNumberType(number);
                    }
                    catch (NumberFormatException v1) {}
                    if (guessedNumberType == null) ** GOTO lbl-1000
                    if (myParameterTypes[i] == guessedNumberType || myParameterTypes[i] == TypeConverter.getObjectClassForSimpleClass(guessedNumberType)) {
                        parameters[i] = TypeConverter.getGuessedNumberValue(number);
                    } else if (TypeConverter.isCompatibleType(myParameterTypes[i], guessedNumberType)) {
                        parameters[i] = TypeConverter.getGuessedNumberValue(number);
                    } else if (myParameterTypes[i] == Character.TYPE || myParameterTypes[i] == Character.class) {
                        s = (String)parameters[i];
                        if (s.length() == 1) {
                            parameters[i] = Character.valueOf(s.charAt(0));
                        } else {
                            methodMayFit = false;
                            this.logger.info("Failed on " + parameters[i] + "(#" + i + ", expected char, got " + parameters[i] + ")");
                        }
                    } else if (myParameterTypes[i].isEnum()) {
                        try {
                            parameters[i] = Enum.valueOf(myParameterTypes[i], (String)parameters[i]);
                        }
                        catch (IllegalArgumentException v2) {
                            this.logger.info("Failed on " + parameters[i] + "(#" + i + ", expected enum " + myParameterTypes[i] + ", got " + parameters[i] + ")");
                            methodMayFit = false;
                        }
                    } else {
                        castSuccessful = true;
                        try {
                            parameterTypes[i].asSubclass(myParameterTypes[i]);
                        }
                        catch (ClassCastException v3) {
                            castSuccessful = false;
                        }
                        if (!castSuccessful) {
                            castSuccessful = true;
                            try {
                                parameterTypes[i].cast(parameters[i]);
                            }
                            catch (ClassCastException v4) {
                                castSuccessful = false;
                            }
                            if (!castSuccessful) {
                                this.logger.info("Failed on " + parameters[i] + "(#" + i + ", expected type " + myParameterTypes[i] + ", got type " + parameterTypes[i] + ")");
                                methodMayFit = false;
                                break;
                            }
                        }
                    }
                }
                ++i;
            }
            if (!methodMayFit) continue;
            methodTocall = method;
            break;
        }
        return methodTocall;
    }

    private static Class<?>[] getParameterTypesForObjects(Object[] objects) {
        Class[] types = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            types[i] = objects[i] != null ? objects[i].getClass() : null;
            ++i;
        }
        return types;
    }

    @Override
    public String getDescription(String commandName) {
        if (!this.methods.containsKey(commandName)) {
            return "(unknown command)";
        }
        Set<java.lang.reflect.Method> methods = this.methods.get(commandName);
        StringBuilder help = new StringBuilder();
        for (java.lang.reflect.Method method : methods) {
            help.append(String.valueOf(this.methodToString(method)) + ", ");
        }
        if (methods.size() > 0) {
            help.delete(help.length() - 2, help.length());
        }
        return "(reflection-call: " + help + ")";
    }

    private String methodToString(java.lang.reflect.Method method) {
        StringBuilder s = new StringBuilder();
        if (method.getReturnType() != Void.class) {
            s.append(String.valueOf(method.getReturnType().getSimpleName()) + " ");
        }
        s.append(String.valueOf(method.getName()) + "(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> c = parameterTypes[i];
            s.append(String.valueOf(c.getSimpleName()) + " " + this.getParameterName(method, i) + ", ");
            ++i;
        }
        if (parameterTypes.length > 0) {
            s.delete(s.length() - 2, s.length());
        }
        s.append(")");
        return s.toString();
    }

    private String getParameterName(java.lang.reflect.Method origMethod, int index) {
        JavaClass javaClass;
        java.lang.reflect.Method method = origMethod;
        if (this.object != null) {
            javaClass = Repository.lookupClass(this.object.getClass());
            java.lang.reflect.Method methodImpl = null;
            try {
                methodImpl = this.object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (methodImpl != null) {
                method = methodImpl;
            }
        } else {
            javaClass = Repository.lookupClass(this.clazz);
        }
        String defaultReturn = "arg" + (index + 1);
        Method method2 = javaClass.getMethod(method);
        if (method2 == null) {
            return defaultReturn;
        }
        LocalVariableTable localVariableTable = method2.getLocalVariableTable();
        if (localVariableTable == null) {
            return defaultReturn;
        }
        LocalVariable localVariable = localVariableTable.getLocalVariable(index + 1);
        if (localVariable == null) {
            return defaultReturn;
        }
        return localVariable.getName();
    }
}

