/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.time;

import de.aristaflow.adept2.util.HashCalc;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarTools {
    public static boolean equals(Calendar c1, Calendar c2, int field) {
        int[] units;
        boolean ret = true;
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 13;
        nArray[8] = 14;
        int[] nArray2 = units = nArray;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            int u = nArray2[n2];
            ret = ret && (u > field || c1.get(u) == c2.get(u));
            ++n2;
        }
        return ret;
    }

    public static Calendar addDays(Calendar day, int daysToAdd) {
        Calendar ret = (Calendar)day.clone();
        ret.add(6, daysToAdd);
        return ret;
    }

    public static Calendar weekdayRelativeTo(int weekday, Calendar day, boolean before) {
        int offset = weekday - day.get(7);
        if (before && offset >= 0) {
            offset -= 7;
        } else if (!before && offset <= 0) {
            offset += 7;
        }
        return CalendarTools.addDays(day, offset);
    }

    public static Calendar getEasterSunday(Calendar year) {
        int i = year.get(1) % 19;
        int j = year.get(1) / 100;
        int k = year.get(1) % 100;
        int l = (19 * i + j - j / 4 - (j - (j + 8) / 25 + 1) / 3 + 15) % 30;
        int m = (32 + 2 * (j % 4) + 2 * (k / 4) - l - k % 4) % 7;
        int n = l + m - 7 * ((i + 11 * l + 22 * m) / 451) + 114;
        int month = n / 31;
        int day = n % 31 + 1;
        return new GregorianCalendar(year.get(1), month - 1, day);
    }

    public static long setDateInMillis(long time, int year, int month, int day) {
        return CalendarTools.setDateInMillis(time, year, month, day, Locale.getDefault());
    }

    public static long setDateInMillis(long time, int year, int month, int day, Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTimeInMillis(time);
        cal.set(year, month, day);
        return cal.getTimeInMillis();
    }

    public static long setTimeInMillis(long date, int hours, int minutes, int seconds) {
        return CalendarTools.setTimeInMillis(date, hours, minutes, seconds, Locale.getDefault());
    }

    public static long setTimeInMillis(long date, int hours, int minutes, int seconds, Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTimeInMillis(date);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return cal.getTimeInMillis();
    }

    public static Calendar createUTCCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static class DayOfYear {
        public int month;
        public int day;

        public DayOfYear(int month, int day) {
            this.month = month;
            this.day = day;
        }

        public DayOfYear(Calendar day) {
            this(day.get(2), day.get(5));
        }

        public int hashCode() {
            return new HashCalc(this.getClass()).feed(this.month).feed(this.day).hashCode();
        }

        public boolean equals(Object otherObject) {
            boolean ret = false;
            if (otherObject instanceof DayOfYear) {
                DayOfYear otherDOY = (DayOfYear)otherObject;
                ret = this.month == otherDOY.month && this.day == otherDOY.day;
            }
            return ret;
        }
    }
}

