/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.time;

import java.util.Date;

public class DateTimeFormat {
    public static String formatDateTime(long dateTime) {
        if (dateTime <= 0L) {
            return DateTimeFormat.formatTime(-dateTime);
        }
        return DateTimeFormat.formatDate(dateTime);
    }

    public static String formatTime(long time) {
        long milliseconds = time % 1000L;
        long seconds = time / 1000L % 60L;
        long minutes = time / 1000L / 60L % 60L;
        long hours = time / 1000L / 60L / 60L % 24L;
        long days = time / 1000L / 60L / 60L / 24L % 7L;
        long weeks = time / 1000L / 60L / 60L / 24L / 7L;
        StringBuilder sb = new StringBuilder();
        if (weeks > 0L) {
            sb.append(weeks).append("w ");
        }
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s ");
        }
        if (milliseconds > 0L) {
            sb.append(milliseconds).append("ms");
        }
        if (sb.length() == 0) {
            sb.append("0s");
        }
        return sb.toString().trim();
    }

    public static String formatDate(long timestamp) {
        return new Date(timestamp).toString();
    }
}

