/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.time;

import de.aristaflow.adept2.util.time.nl.PublicHolidays;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;

public class TimeCalculations {
    private PublicHolidays localHolidays;

    public TimeCalculations() {
        this(Locale.getDefault());
    }

    public TimeCalculations(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.aristaflow.adept2.util.i18n.AristaFlowBundle", locale);
        this.localHolidays = (PublicHolidays)bundle.getObject(PublicHolidays.class.getCanonicalName());
    }

    public Calendar getWorkingDayAfter(Calendar fromDate, int workingDaysToAdd) {
        Calendar ret = (Calendar)fromDate.clone();
        int rem = workingDaysToAdd;
        while (rem > 0) {
            ret.add(6, 1);
            if (!this.localHolidays.isWorkingDay(ret)) continue;
            --rem;
        }
        while (!this.localHolidays.isWorkingDay(ret)) {
            ret.add(6, 1);
        }
        return ret;
    }

    public static long timeLeft(long startInNanos, long duration, TimeUnit unit) {
        long elapsed = System.nanoTime() - startInNanos;
        return duration - unit.convert(elapsed, TimeUnit.NANOSECONDS);
    }
}

