/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.time.nl;

import de.aristaflow.adept2.util.time.CalendarTools;
import de.aristaflow.adept2.util.time.nl.PublicHolidays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LocalPublicHolidays
implements PublicHolidays {
    protected Map<CalendarTools.DayOfYear, String> getFixedHolidays() {
        return new HashMap<CalendarTools.DayOfYear, String>(0);
    }

    protected Map<Calendar, String> getFloatingHolidays(Calendar year) {
        return new HashMap<Calendar, String>(0);
    }

    protected Map<Calendar, String> getFixedHolidays(Calendar year) {
        Set<Map.Entry<CalendarTools.DayOfYear, String>> fixedHoliday = this.getFixedHolidays().entrySet();
        HashMap<GregorianCalendar, String> ret = new HashMap<GregorianCalendar, String>(fixedHoliday.size());
        for (Map.Entry<CalendarTools.DayOfYear, String> entry : fixedHoliday) {
            ret.put(new GregorianCalendar(year.get(1), entry.getKey().month, entry.getKey().day), entry.getValue());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public int[] getWorkingWeekdays() {
        return new int[]{2, 3, 4, 5, 6};
    }

    @Override
    public boolean isWorkingDay(Calendar day) {
        int weekday = day.get(7);
        int[] nArray = this.getWorkingWeekdays();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int wd = nArray[n2];
            if (weekday == wd) {
                return !this.isPublicHoliday(day);
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPublicHoliday(Calendar day) {
        boolean ret = this.getFixedHolidays().containsKey(new CalendarTools.DayOfYear(day.get(2), day.get(5)));
        if (!ret) {
            ret = this.getFloatingHolidays(day).containsKey(day);
        }
        return ret;
    }

    @Override
    public String getPublicHolidayName(Calendar day) {
        for (Map.Entry<Calendar, String> entry : this.getFloatingHolidays(day).entrySet()) {
            if (!CalendarTools.equals(entry.getKey(), day, 5)) continue;
            return entry.getValue();
        }
        return this.getFixedHolidays().get(new CalendarTools.DayOfYear(day));
    }

    @Override
    public Calendar[] getPublicHolidaysForMonth(Calendar month) {
        TreeSet<Calendar> ret = new TreeSet<Calendar>();
        for (Calendar publicHoliday : this.getFloatingHolidays(month).keySet()) {
            if (publicHoliday.get(2) != month.get(2)) continue;
            ret.add(publicHoliday);
        }
        for (Calendar publicHoliday : this.getFixedHolidays(month).keySet()) {
            if (publicHoliday.get(2) != month.get(2)) continue;
            ret.add(publicHoliday);
        }
        return ret.toArray(new Calendar[ret.size()]);
    }

    @Override
    public Calendar[] getPublicHolidaysForYear(Calendar year) {
        TreeSet<Calendar> ret = new TreeSet<Calendar>(this.getFloatingHolidays(year).keySet());
        ret.addAll(this.getFixedHolidays(year).keySet());
        return ret.toArray(new Calendar[ret.size()]);
    }
}

