/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.time.nl;

import de.aristaflow.adept2.util.time.CalendarTools;
import de.aristaflow.adept2.util.time.nl.LocalPublicHolidays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class LocalPublicHolidays_de_DE
extends LocalPublicHolidays {
    protected Map<CalendarTools.DayOfYear, String> fixedHolidays = new HashMap<CalendarTools.DayOfYear, String>(8);

    public LocalPublicHolidays_de_DE() {
        this.fixedHolidays.put(new CalendarTools.DayOfYear(0, 1), "Neujahr");
        this.fixedHolidays.put(new CalendarTools.DayOfYear(4, 1), "Maifeiertag");
        this.fixedHolidays.put(new CalendarTools.DayOfYear(9, 3), "Tag der deutschen Einheit");
        this.fixedHolidays.put(new CalendarTools.DayOfYear(11, 25), "1. Weihnachtstag");
        this.fixedHolidays.put(new CalendarTools.DayOfYear(11, 26), "2. Weihnachtstag");
    }

    @Override
    protected Map<CalendarTools.DayOfYear, String> getFixedHolidays() {
        return this.fixedHolidays;
    }

    @Override
    protected Map<Calendar, String> getFloatingHolidays(Calendar year) {
        HashMap<Calendar, String> ret = new HashMap<Calendar, String>(8);
        Calendar easterSunday = CalendarTools.getEasterSunday(year);
        ret.put(CalendarTools.addDays(easterSunday, -2), "Karfreitag");
        ret.put(easterSunday, "Ostersonntag");
        ret.put(CalendarTools.addDays(easterSunday, 1), "Ostermontag");
        ret.put(CalendarTools.addDays(easterSunday, 39), "Christi Himmelfahrt");
        ret.put(CalendarTools.addDays(easterSunday, 49), "Pfingstsonntag");
        ret.put(CalendarTools.addDays(easterSunday, 50), "Pfingstmontag");
        return ret;
    }
}

