/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.types;

import de.aristaflow.adept2.util.types.Pair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerialisablePair<F, S>
extends Pair<F, S>
implements Serializable {
    private static final long serialVersionUID = -7440615635172129321L;

    public SerialisablePair(F first, S second) {
        super(first, second);
        if (first != null && !(first instanceof Serializable) || second != null && !(second instanceof Serializable)) {
            String msg = "All of the elements of the pair need to be serialisable.";
            throw new IllegalArgumentException(msg);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.first);
        out.writeObject(this.second);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.first = in.readObject();
        this.second = in.readObject();
    }
}

