/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.types;

import de.aristaflow.adept2.util.types.Triple;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerialisableTriple<F, S, T>
extends Triple<F, S, T>
implements Serializable {
    private static final long serialVersionUID = 3032712529639849421L;

    public SerialisableTriple(F first, S second, T third) {
        super(first, second, third);
        if (first != null && !(first instanceof Serializable) || second != null && !(second instanceof Serializable) || third != null && !(third instanceof Serializable)) {
            String msg = "All of the elements of the triple need to be serialisable.";
            throw new IllegalArgumentException(msg);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.first);
        out.writeObject(this.second);
        out.writeObject(this.third);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.first = in.readObject();
        this.second = in.readObject();
        this.third = in.readObject();
    }
}

