/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util.xml;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.FileTools;
import de.aristaflow.adept2.util.JavaVersion;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLHelperTools {
    public static final String ENCODING = "UTF-8";
    protected static final Logger logger = LoggerTools.getLogger(XMLHelperTools.class);
    private static final String[][] XML_ENTITIES = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"'", "&apos;"}, {"\"", "&quot;"}};

    public static boolean isValid(Document document, Schema schema) {
        try {
            XMLHelperTools.validateDoc(document, schema);
        }
        catch (XMLFormatException ex) {
            ex.printStackTrace();
            try {
                String msg = "The following XML is not valid:\n%s";
                String documentString = XMLHelperTools.getXMLStringForDocument(document);
                msg = String.format(msg, documentString);
                System.err.println(msg);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isDocumentValid(Document document, Schema schema) {
        try {
            XMLHelperTools.validateDocument(document, schema);
        }
        catch (XMLFormatException ex) {
            ex.printStackTrace();
            try {
                String msg = "The following XML is not valid:\n%s";
                String documentString = XMLHelperTools.getXMLStringForDocument(document);
                msg = String.format(msg, documentString);
                System.err.println(msg);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static boolean isStreamValid(InputStream is, Schema schema) {
        try {
            XMLHelperTools.validateStream(is, schema);
        }
        catch (XMLFormatException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void validateAndPrintDoc(Document doc, Schema schema) throws XMLFormatException, IOException {
        try {
            XMLHelperTools.validateDoc(doc, schema);
        }
        catch (XMLFormatException e) {
            System.out.println("--------------------------------------------------");
            System.out.println(XMLHelperTools.getXMLStringForDocument(doc));
            System.out.println("--------------------------------------------------");
            throw e;
        }
    }

    @Deprecated
    public static void validatePrintDocument(Document doc, Schema schema) throws XMLFormatException, IOException {
        try {
            XMLHelperTools.validateDocument(doc, schema);
        }
        catch (XMLFormatException e) {
            System.out.println("--------------------------------------------------");
            System.out.println(XMLHelperTools.getXMLStringForDocument(doc));
            System.out.println("--------------------------------------------------");
            throw e;
        }
    }

    public static void validateDoc(Document document, Schema schema) throws XMLFormatException {
        ArgChecks.checkForNull(schema, "schema");
        if (JavaVersion.getCurrent().satisfiesMinimum("1.6")) {
            XMLHelperTools.validateDocument(document, schema);
        } else {
            try {
                InputStream is = XMLHelperTools.getInputStreamForDocument(document);
                XMLHelperTools.validateStream(is, schema);
            }
            catch (IOException ioe) {
                String msg = "IOException encountered when transforming the document to a stream for Java 5.";
                logger.log(Level.SEVERE, msg, ioe);
                throw new XMLFormatException(msg, ioe);
            }
        }
    }

    @Deprecated
    public static void validateDocument(Document document, Schema schema) throws XMLFormatException {
        ArgChecks.checkForNull(schema, "schema");
        try {
            Validator xmlValidator = schema.newValidator();
            xmlValidator.validate(new DOMSource(document));
        }
        catch (SAXException ex) {
            throw new XMLFormatException(ex);
        }
        catch (IOException ioe) {
            String msg = "IOException encountered where none should have been thrown, since no files or other external sources were involved!";
            logger.log(Level.SEVERE, msg, ioe);
            throw new IllegalStateException(msg, ioe);
        }
    }

    public static void validateStream(InputStream is, Schema schema) throws XMLFormatException {
        ArgChecks.checkForNull(schema, "schema");
        try {
            Validator xmlValidator = schema.newValidator();
            xmlValidator.validate(new StreamSource(is));
        }
        catch (SAXException ex) {
            throw new XMLFormatException(ex);
        }
        catch (IOException ioe) {
            String msg = "IOException encountered where none should have been thrown, since no files or other external sources were involved!";
            logger.log(Level.SEVERE, msg, ioe);
            throw new IllegalStateException(msg, ioe);
        }
    }

    public static String replaceWithXMLEntities(String string) {
        StringBuilder sb = new StringBuilder(string);
        String[][] stringArray = XML_ENTITIES;
        int n = XML_ENTITIES.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String[] entPair = stringArray[n2];
            String entity = entPair[0];
            String replacement = entPair[1];
            int offset = 0;
            while ((index = sb.indexOf(entity, offset)) != -1) {
                sb.replace(index, index + entity.length(), replacement);
                offset = index + replacement.length();
            }
            ++n2;
        }
        return sb.toString();
    }

    public static Document getDocumentFromString(String string, Schema schema) throws XMLFormatException, IOException {
        return XMLHelperTools.getDocumentFromStream(new ByteArrayInputStream(string.getBytes(ENCODING)), schema, null, true);
    }

    public static Document getDocumentFromFile(File file, Schema schema, ErrorHandler errorHandler) throws XMLFormatException, FileNotFoundException, IOException {
        Document document;
        ArgChecks.checkForNull(file, "file");
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            Document document2 = XMLHelperTools.getDocumentFromStream(in, schema, errorHandler, true);
            in = FileTools.close(in);
            document = document2;
        }
        catch (FileNotFoundException ex) {
            try {
                logger.log(Level.SEVERE, "File not found: " + file.toString(), ex);
                throw ex;
            }
            catch (Throwable throwable) {
                FileTools.closeQuietly(in);
                throw throwable;
            }
        }
        FileTools.closeQuietly(in);
        return document;
    }

    public static Document getDocumentFromStream(InputStream inputStream) throws XMLFormatException, IOException {
        return XMLHelperTools.getDocumentFromStream(inputStream, null, null, true);
    }

    public static Document getDocumentFromStream(InputStream inputStream, Schema schema, ErrorHandler errorHandler, boolean nsAware) throws XMLFormatException, IOException {
        Document document;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(nsAware);
        domFactory.setValidating(false);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            if (errorHandler != null) {
                builder.setErrorHandler(errorHandler);
            }
            document = builder.parse(inputStream);
            if (schema != null) {
                XMLHelperTools.validateDocument(document, schema);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "An IOException occurred while reading the document!", ex);
            throw ex;
        }
        catch (ParserConfigurationException ex) {
            String message = "A configuration error occurred while creating the XML parser!";
            logger.log(Level.SEVERE, message, ex);
            throw new RuntimeException(message, ex);
        }
        catch (SAXException ex) {
            throw new XMLFormatException("An error occurred while parsing the document", ex);
        }
        return document;
    }

    public static Document createDocument() {
        DocumentBuilder domBuilder;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            domBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String message = "Could not get document builder: " + pce.toString();
            logger.log(Level.SEVERE, message, pce);
            throw new RuntimeException(message, pce);
        }
        return domBuilder.newDocument();
    }

    public static String getXMLStringForDocument(Document document) throws IOException {
        return XMLHelperTools.getXMLStringForInputStream(XMLHelperTools.getInputStreamForDocument(document));
    }

    public static String getXMLStringForInputStream(InputStream is) throws IOException {
        StringBuilder s;
        block6: {
            InputStreamReader isReader = new InputStreamReader(is, Charset.forName(ENCODING));
            s = new StringBuilder();
            try {
                try {
                    char[] buf = new char[4096];
                    int read = isReader.read(buf);
                    while (read != -1) {
                        s.append(buf, 0, read);
                        read = isReader.read(buf);
                    }
                }
                catch (IOException e) {
                    String message = "IOException while reading our own XML input stream!";
                    logger.log(Level.SEVERE, message, e);
                    isReader.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                isReader.close();
                throw throwable;
            }
            isReader.close();
        }
        return s.toString();
    }

    public static InputStream getInputStreamForDocument(Document document) throws IOException {
        return new ByteArrayInputStream(XMLHelperTools.getByteArrayForDocument(document));
    }

    public static byte[] getByteArrayForDocument(Document document) throws IOException {
        return XMLHelperTools.getOutputStreamForDocument(document).toByteArray();
    }

    public static ByteArrayOutputStream getOutputStreamForDocument(Document document) throws IOException {
        return XMLHelperTools.getOutputStreamForDocument(document, null);
    }

    public static ByteArrayOutputStream getOutputStreamForDocument(Document document, Source xslt) throws IOException {
        ByteArrayOutputStream xmlOut = new ByteArrayOutputStream(4096);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)xmlOut, ENCODING);
        try {
            Transformer transformer = xslt != null ? TransformerFactory.newInstance().newTransformer(xslt) : TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", ENCODING);
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return xmlOut;
    }

    private static void writeDocument(Document document, StreamResult out) throws IOException {
        try {
            DOMSource source = new DOMSource(document);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer xformer = factory.newTransformer();
            xformer.setOutputProperty("standalone", "no");
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("encoding", ENCODING);
            xformer.transform(source, out);
        }
        catch (TransformerConfigurationException ex) {
            String msg = "there is no transformer matching the configuration";
            logger.log(Level.SEVERE, msg, ex);
            IOException newEx = new IOException(msg);
            newEx.initCause(ex);
        }
        catch (TransformerException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            IOException newEx = new IOException();
            newEx.initCause(ex);
        }
    }

    public static void writeDocumentToStream(Document document, OutputStream out) throws IOException {
        XMLHelperTools.writeDocument(document, new StreamResult(out));
    }

    public static void writeDocumentToFile(Document document, File file, Schema schema) throws IOException, XMLFormatException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING);
            if (schema != null) {
                XMLHelperTools.validateDocument(document, schema);
            }
            XMLHelperTools.writeDocument(document, new StreamResult(writer));
            writer = FileTools.close(writer);
        }
        catch (Throwable throwable) {
            FileTools.closeQuietly(writer);
            throw throwable;
        }
        FileTools.closeQuietly(writer);
    }

    public static int getParsedID(Node node) {
        return XMLHelperTools.getParsedID(node.getTextContent());
    }

    public static int getParsedID(String nodeValue) {
        int id = 0;
        try {
            id = Integer.parseInt(nodeValue.substring(1));
        }
        catch (NumberFormatException e) {
            logger.log(Level.SEVERE, "Error parsing ID from value: '" + nodeValue + "'!", e);
        }
        return id;
    }

    public static boolean hasTagName(Node n, String name) {
        boolean ret = false;
        if (n instanceof Element) {
            ret = XMLHelperTools.hasTagName((Element)n, name);
        }
        return ret;
    }

    public static boolean hasTagName(Element e, String name) {
        boolean ret = false;
        if (e != null) {
            ret = XMLHelperTools.getTagName(e).equals(name);
        }
        return ret;
    }

    public static String getTagName(Element e) {
        String tagName = e.getLocalName();
        if (tagName == null) {
            tagName = e.getTagName();
        }
        return tagName;
    }

    public static Element getElement(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        if (node.getNextSibling() == null) {
            return null;
        }
        return XMLHelperTools.getElement(node.getNextSibling());
    }
}

