/*
 * Decompiled with CFR 0.152.
 */
package l10n.de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.util.ArgChecks;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ListUIMessages {
    private static final String BUNDLE_NAME = ListUIMessages.class.getName();
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Activator.getAdministrationService().getActiveAgent().getLocale());

    public static String getString(String key) {
        ArgChecks.checkForNull(key, "key");
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, Object ... args) {
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(args, "args");
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    private ListUIMessages() {
    }
}

