/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.ui;

import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.util.FontTools;
import de.aristaflow.adept2.ui.util.RadioGroupManager;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DACConnectionWizardPage
extends ExecutableComponentWizardPage
implements FocusListener {
    public static final String PAGE_NAME = "de.aristaflow.db.SQL#dataSource";
    protected Button rbDataSource;
    protected Text txtDataSourceName;
    protected Button rbConnection;
    protected Combo txtDriver;
    protected Text txtConnectionURL;
    protected Text txtUserName;
    protected Text txtPassword;
    protected Button cbSavePassword;
    protected Text txtDescription;
    protected RadioGroupManager radioGroup;
    Composite container;

    public DACConnectionWizardPage(ExecutableComponentWizard pageSet, String title) {
        super(pageSet, PAGE_NAME);
        this.setTitle(title);
        this.setDescription("Specify your SQL connection settings here");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        this.container.setLayout((Layout)containerLayout);
        this.radioGroup = new RadioGroupManager(this.container);
        this.rbDataSource = new Button(this.container, 16);
        this.rbDataSource.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.rbDataSource.setText("Data Source");
        FontTools.changeFont((Control)this.rbDataSource, (int)0, (int)1);
        new Label(this.container, 0).setText("JNDI logical name:");
        this.txtDataSourceName = new Text(this.container, 2052);
        this.txtDataSourceName.setLayoutData((Object)new GridData(4, 1, true, false));
        this.txtDataSourceName.addModifyListener(this.getAutoCommitModifyListener());
        this.radioGroup.add(this.rbDataSource, new Control[]{this.txtDataSourceName});
        this.rbConnection = new Button(this.container, 16);
        this.rbConnection.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).indent(0, 10).create());
        this.rbConnection.setText("Direct Connection");
        FontTools.changeFont((Control)this.rbConnection, (int)0, (int)1);
        new Label(this.container, 0).setText("Driver:");
        this.txtDriver = new Combo(this.container, 2052);
        this.txtDriver.setLayoutData((Object)new GridData(4, 1, true, false));
        this.txtDriver.setVisibleItemCount(10);
        this.txtDriver.add("com.ibm.db2.jcc.DB2Driver");
        this.txtDriver.add("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        this.txtDriver.add("oracle.jdbc.OracleDriver");
        this.txtDriver.add("org.apache.derby.jdbc.ClientDriver");
        this.txtDriver.add("org.apache.derby.jdbc.EmbeddedDriver");
        this.txtDriver.add("org.postgresql.Driver");
        this.txtDriver.addModifyListener(this.getAutoCommitModifyListener());
        this.txtDriver.addFocusListener((FocusListener)this);
        new Label(this.container, 0).setText("Connection URL:");
        this.txtConnectionURL = new Text(this.container, 2052);
        this.txtConnectionURL.setLayoutData((Object)new GridData(4, 1, true, false));
        this.txtConnectionURL.addModifyListener(this.getAutoCommitModifyListener());
        this.txtConnectionURL.addFocusListener((FocusListener)this);
        new Label(this.container, 0).setText("User Name:");
        this.txtUserName = new Text(this.container, 2052);
        this.txtUserName.setLayoutData((Object)new GridData(4, 1, true, false));
        this.txtUserName.addModifyListener(this.getAutoCommitModifyListener());
        this.txtUserName.addFocusListener((FocusListener)this);
        new Label(this.container, 0).setText("Password:");
        this.txtPassword = new Text(this.container, 0x400804);
        this.txtPassword.setLayoutData((Object)new GridData(4, 1, true, false));
        this.txtPassword.addModifyListener(this.getAutoCommitModifyListener());
        this.txtPassword.addFocusListener((FocusListener)this);
        this.cbSavePassword = new Button(this.container, 32);
        this.cbSavePassword.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.cbSavePassword.setText("Save Password");
        this.cbSavePassword.addSelectionListener(this.getAutoCommitSelectionListener());
        this.radioGroup.add(this.rbConnection, new Control[]{this.txtDriver, this.txtConnectionURL, this.txtUserName, this.txtPassword, this.cbSavePassword});
        this.radioGroup.select(this.rbConnection);
        this.rbDataSource.addSelectionListener(this.getAutoCommitSelectionListener());
        this.rbConnection.addSelectionListener(this.getAutoCommitSelectionListener());
        Button btnCheckConnection = new Button(this.container, 8);
        btnCheckConnection.setText("Check connection");
        btnCheckConnection.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 4).span(2, 1).create());
        btnCheckConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DACConnectionWizardPage.this.testConnection();
            }
        });
        Label lbl = new Label(this.container, 0);
        lbl.setText("Description:");
        GridData gd = GridDataFactory.swtDefaults().span(2, 1).indent(0, 10).create();
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.txtDescription = new Text(this.container, 2634);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.txtDescription.setLayoutData((Object)gd);
        this.txtDescription.setEnabled(false);
        this.setControl((Control)this.container);
        this.refresh();
    }

    public void focusGained(FocusEvent e) {
        ConfigurationDescription confDesc = this.getConfigurationDescription();
        String description = confDesc == null ? "<description not available>" : (e.widget == this.txtConnectionURL ? confDesc.getEntry("DB.ConnectionURL").getDescription() : (e.widget == this.txtDriver ? confDesc.getEntry("DB.Driver").getDescription() : (e.widget == this.txtPassword ? confDesc.getEntry("DB.Password").getDescription() : (e.widget == this.txtUserName ? confDesc.getEntry("DB.UserName").getDescription() : null))));
        if (description != null) {
            this.txtDescription.setText(description);
        }
    }

    public Connection getConnection() throws NamingException, SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String password;
        ChangeableActivityConfiguration conf = this.getData().getConfiguration();
        if (this.rbDataSource.getSelection()) {
            InitialContext ctx = new InitialContext();
            String dataSourceName = conf.getString("DB.DataSourceName");
            Object object = ctx.lookup(dataSourceName);
            if (!(object instanceof DataSource)) {
                String msg = "The object referenced by the logical name '%s' is no javax.sql.DataSource: %s";
                msg = String.format(msg, dataSourceName, object == null ? null : object.getClass().getName());
                throw new NamingException(msg);
            }
            DataSource dataSource = (DataSource)object;
            return dataSource.getConnection();
        }
        String driver = conf.getString("DB.Driver");
        String connectionURL = conf.getString("DB.ConnectionURL");
        String userName = conf.getString("DB.UserName");
        if (this.cbSavePassword.getSelection()) {
            password = conf.getString("DB.Password");
            try {
                password = ConfigurationTools.parsePassword((String)password);
            }
            catch (GeneralSecurityException generalSecurityException) {}
        } else {
            password = this.txtPassword.getText();
        }
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(connectionURL, userName, password);
    }

    public void focusLost(FocusEvent e) {
    }

    /*
     * Exception decompiling
     */
    public void testConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loadData() {
        ChangeableActivityConfiguration conf = this.getData().getConfiguration();
        if (conf.getString("DB.DataSourceName") != null) {
            this.txtDataSourceName.setText(conf.getString("DB.DataSourceName"));
            this.radioGroup.select(this.rbDataSource);
        } else {
            if (conf.getString("DB.Driver") == null) {
                this.txtDriver.setText("");
            } else {
                this.txtDriver.setText(conf.getString("DB.Driver"));
            }
            this.txtDriver.setEnabled(!conf.isFixed("DB.Driver"));
            if (conf.getString("DB.ConnectionURL") == null) {
                this.txtConnectionURL.setText("");
            } else {
                this.txtConnectionURL.setText(conf.getString("DB.ConnectionURL"));
            }
            this.txtConnectionURL.setEditable(!conf.isFixed("DB.ConnectionURL"));
            if (conf.getString("DB.UserName") == null) {
                this.txtUserName.setText("");
            } else {
                this.txtUserName.setText(conf.getString("DB.UserName"));
            }
            this.txtUserName.setEditable(!conf.isFixed("DB.UserName"));
            String password = conf.getString("DB.Password");
            if (password == null || password.length() == 0) {
                this.txtPassword.setText("");
                this.cbSavePassword.setSelection(false);
            } else {
                this.txtPassword.setText(password);
                this.cbSavePassword.setSelection(true);
            }
            this.txtPassword.setEditable(!conf.isFixed("DB.Password"));
            this.cbSavePassword.setEnabled(!conf.isFixed("DB.Password"));
            this.radioGroup.select(this.rbConnection);
        }
    }

    protected void saveData() {
        ChangeableActivityConfiguration conf = this.getData().getConfiguration();
        if (this.rbDataSource.getSelection()) {
            if (!conf.isFixed("DB.DataSourceName")) {
                conf.setString("DB.DataSourceName", this.txtDataSourceName.getText());
            }
            conf.remove("DB.Driver");
            conf.remove("DB.ConnectionURL");
            conf.remove("DB.UserName");
            conf.remove("DB.Password");
        } else if (this.rbConnection.getSelection()) {
            if (!conf.isFixed("DB.Driver")) {
                conf.setString("DB.Driver", this.txtDriver.getText());
            }
            if (!conf.isFixed("DB.ConnectionURL")) {
                conf.setString("DB.ConnectionURL", this.txtConnectionURL.getText());
            }
            if (!conf.isFixed("DB.UserName")) {
                conf.setString("DB.UserName", this.txtUserName.getText());
            }
            if (!conf.isFixed("DB.Password")) {
                if (this.cbSavePassword.getSelection()) {
                    String password = this.txtPassword.getText();
                    conf.setString("DB.Password", password);
                } else {
                    conf.setString("DB.Password", "");
                }
            }
            conf.remove("DB.DataSourceName");
        }
    }
}

