/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.ui;

import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DACExecuteStatementsWizardPage
extends ExecutableComponentWizardPage {
    public static final String PAGE_NAME = "de.aristaflow.db.SQL#executeStatements";
    Text txtStatements;
    Button checkBoxSerialiseResultSet;

    public DACExecuteStatementsWizardPage(ExecutableComponentWizard pageSet, String title) {
        super(pageSet, PAGE_NAME);
        this.setTitle(title);
        this.setDescription("Specify your SQL statements here");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        container.setLayout((Layout)containerLayout);
        this.txtStatements = new Text(container, 2114);
        this.txtStatements.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(400, -1).create());
        this.txtStatements.addModifyListener(this.getAutoCommitModifyListener());
        Label notice = new Label(container, 64);
        notice.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
        notice.setText("Note: For stored procedure calls the JDBC escape syntax for function calls must be used. Examples: {? = call proc_name(?,...)} or {call proc_name(?,...)} where ? represents a parameter reference.");
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        this.checkBoxSerialiseResultSet = new Button(container, 32);
        this.checkBoxSerialiseResultSet.setText("Serialise the ResultSet to a UDT");
        this.checkBoxSerialiseResultSet.setLayoutData((Object)new GridData(4, 0, true, false));
        this.checkBoxSerialiseResultSet.addSelectionListener(this.getAutoCommitSelectionListener());
        this.setControl((Control)container);
        this.refresh();
    }

    protected void loadData() {
        ChangeableActivityConfiguration conf = this.getData().getConfiguration();
        if (conf.getString("SQLStatements") == null) {
            this.txtStatements.setText("");
        } else {
            this.txtStatements.setText(conf.getString("SQLStatements"));
        }
        if (Boolean.parseBoolean(conf.getString("SerialiseResultSet"))) {
            this.checkBoxSerialiseResultSet.setSelection(true);
        } else {
            this.checkBoxSerialiseResultSet.setSelection(false);
        }
    }

    protected void saveData() {
        ChangeableActivityConfiguration conf = this.getData().getConfiguration();
        conf.setString("SQLStatements", this.txtStatements.getText());
        if (this.checkBoxSerialiseResultSet.getSelection()) {
            conf.setString("SerialiseResultSet", "true");
        } else {
            conf.remove("SerialiseResultSet");
        }
    }
}

