/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor;

import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ModellingClientService;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CSTNUEditorActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.uniulm.dbis.aristaflow.time.ui.cstnueditor";
    private static CSTNUEditorActivator plugin;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CSTNUEditorActivator getDefault() {
        return plugin;
    }

    public static ModellingClientService getModellingClientService() {
        BundleContext context = CSTNUEditorActivator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ModellingClientService.class.getName());
        return (ModellingClientService)context.getService(ref);
    }

    public static ADEPT2ClientService getFullService() {
        BundleContext context = CSTNUEditorActivator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ADEPT2ClientService.class.getName());
        return (ADEPT2ClientService)context.getService(ref);
    }

    public static TimeManager getTimeManager() {
        TimeManager timeManager;
        ADEPT2ClientService fullService = CSTNUEditorActivator.getFullService();
        SessionToken sessionToken = fullService.getSessionToken();
        try {
            timeManager = (TimeManager)fullService.getServiceOfType(sessionToken, "TimeManager", TimeManager.class);
        }
        catch (ServiceNotKnownException serviceNotKnownException) {
            return null;
        }
        return timeManager;
    }

    public static void handleError(final Shell shell, final String title, final String message, final IStatus status) {
        CSTNUEditorActivator.getDefault().getLog().log(status);
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            }
        });
    }

    public static void handleError(Shell shell, Throwable e) {
        Assert.isNotNull((Object)e);
        IStatus errorStatus = CSTNUEditorActivator.getErrorStatus(e);
        CSTNUEditorActivator.handleError(shell, "An error occurred", e.getMessage(), errorStatus);
    }

    public static IStatus getErrorStatus(Throwable e) {
        return CSTNUEditorActivator.getErrorStatus(e.getMessage(), e);
    }

    public static IStatus getErrorStatus(String msg) {
        Status errorStatus = new Status(4, PLUGIN_ID, msg);
        return errorStatus;
    }

    public static IStatus getErrorStatus(String msg, Throwable e) {
        Status errorStatus = new Status(4, PLUGIN_ID, msg, e);
        return errorStatus;
    }
}

