/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.actions;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.STNU;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.CSTNUEditorActivator;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.EclipseTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUEditor;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUInstanceEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;

public class AnalyzeNetworkAction
implements IEditorActionDelegate {
    private IEditorPart activeEditor;

    public void run(IAction action) {
        EditorPart editor;
        TCN<LabeledTimePoint, LabeledEdge> tcn = null;
        if (this.activeEditor instanceof CSTNUEditor) {
            editor = (CSTNUEditor)this.activeEditor;
            if (editor.isDirty()) {
                String title = "Unsaved Changes";
                String msg = "The time model in the editor contains changes. Do you want to save them before executing the time model?";
                String[] buttonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dlg = new MessageDialog(this.activeEditor.getEditorSite().getShell(), title, null, msg, 3, buttonLabels, 0);
                int returnCode = dlg.open();
                switch (returnCode) {
                    case 0: {
                        this.activeEditor.getSite().getPage().saveEditor((IEditorPart)editor, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            tcn = editor.getTCN();
        }
        if (this.activeEditor instanceof CSTNUInstanceEditor) {
            editor = (CSTNUInstanceEditor)this.activeEditor;
            tcn = editor.getTCN();
        }
        if (tcn == null) {
            return;
        }
        final ChangeableTCN network = (ChangeableTCN)tcn.clone();
        IProgressService ps = EclipseTools.getWorkbenchWindow().getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final List list = AnalyzeNetworkAction.this.analyze((ChangeableTCN<LabeledTimePoint, LabeledEdge>)network);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AnalyzeNetworkAction.this.showResults(list);
                            }
                        });
                    }
                    catch (InconsistencyException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Network is inconsistent", (String)("Cannot analyze the network because it is inconsistent:\n" + e.getMessage()));
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            CSTNUEditorActivator.handleError(Display.getDefault().getActiveShell(), e.getCause());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private List<AnalysisResult> analyze(ChangeableTCN<LabeledTimePoint, LabeledEdge> network) throws TCNInconsistencyException, InterruptedException {
        TCNSolver solver = TCNAlgorithms.getSolver(network);
        solver.solve(network);
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>();
        for (LabeledTimePoint tp1 : network.getTimePoints()) {
            for (LabeledTimePoint tp2 : network.getTimePoints()) {
                if (tp1 == tp2) continue;
                AnalysisResult analysis = new AnalysisResult(tp1, tp2);
                LabeledEdge minEdge = (LabeledEdge)network.getEdge((TCNTimePoint)tp2, (TCNTimePoint)tp1);
                LabeledEdge maxEdge = (LabeledEdge)network.getEdge((TCNTimePoint)tp1, (TCNTimePoint)tp2);
                analysis.minDist = minEdge != null ? TCNAlgorithms.getTimeDistance((TCNEdge)minEdge, (boolean)false) : null;
                TimeDistance timeDistance = analysis.minDist = analysis.minDist != null ? analysis.minDist.neg() : null;
                if (network instanceof STNU) {
                    analysis.minGuard = TCNAlgorithms.getMinGuardDistance((STNU)((STNU)network), (TCNTimePoint)tp1, (TCNTimePoint)tp2);
                    analysis.maxGuard = TCNAlgorithms.getMaxGuardDistance(network, (TCNTimePoint)tp1, (TCNTimePoint)tp2);
                }
                analysis.wait = minEdge == null || minEdge.isContingentDuration() ? null : TCNAlgorithms.getContingentMaxValue((TCNEdge)minEdge);
                analysis.maxDist = maxEdge != null ? TCNAlgorithms.getTimeDistance((TCNEdge)maxEdge, (boolean)false) : null;
                analysis.contingency = TCNAlgorithms.getContingency(network, (TCNTimePoint)tp1, (TCNTimePoint)tp2);
                results.add(analysis);
            }
        }
        return results;
    }

    private void showResults(List<AnalysisResult> list) {
        Shell shell = new Shell(Display.getCurrent());
        ListDialog dialog = new ListDialog(shell){

            protected int getTableStyle() {
                return super.getTableStyle() & 0xFFFFFFFB | 0x10000 | 2;
            }

            protected int getShellStyle() {
                return 2160;
            }
        };
        dialog.setAddCancelButton(false);
        dialog.setBlockOnOpen(false);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new AnalysisLabelProvider());
        dialog.setInput(list);
        dialog.setWidthInChars(85);
        dialog.setHeightInChars(30);
        dialog.setTitle("Analysis Results");
        dialog.setMessage("Network analysis results");
        dialog.create();
        TableViewer tableViewer = dialog.getTableViewer();
        tableViewer.getTable().setHeaderVisible(true);
        this.createColumns(tableViewer, new String[]{"From", "To", "minDist", "minGuard", "maxGuard", "wait", "maxDist", "contingency"}, new int[]{50, 50, 60, 70, 70, 60, 60, 60});
        tableViewer.setLabelProvider((IBaseLabelProvider)new AnalysisLabelProvider());
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.setInput(list);
        dialog.open();
    }

    protected void createColumns(TableViewer tableViewer, String[] columnNames, int[] columnSizes) {
        if (columnNames.length != columnSizes.length) {
            throw new IllegalArgumentException("columnNames.length != columnSizes.length");
        }
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(tableViewer.getTable(), 0);
            column.setText(columnNames[i]);
            if (columnSizes[i] >= 0) {
                column.setWidth(columnSizes[i]);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public class AnalysisLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            AnalysisResult analysis = (AnalysisResult)element;
            switch (columnIndex) {
                case 0: {
                    return analysis.tp1.toString();
                }
                case 1: {
                    return analysis.tp2.toString();
                }
                case 2: {
                    return analysis.minDist != null ? "" + analysis.minDist.toSeconds() : "-";
                }
                case 3: {
                    return analysis.minGuard != null ? "" + analysis.minGuard.toSeconds() : "-";
                }
                case 4: {
                    return analysis.maxGuard != null ? "" + analysis.maxGuard.toSeconds() : "-";
                }
                case 5: {
                    return analysis.wait != null ? "" + analysis.wait.toSeconds() : "-";
                }
                case 6: {
                    return analysis.maxDist != null ? "" + analysis.maxDist.toSeconds() : "-";
                }
                case 7: {
                    return analysis.contingency != null ? "" + analysis.contingency.toSeconds() : "-";
                }
            }
            return null;
        }

        public String getText(Object element) {
            AnalysisResult analysis = (AnalysisResult)element;
            return String.valueOf(analysis.tp1.toString()) + "->" + analysis.tp2.toString();
        }
    }

    public class AnalysisResult {
        private LabeledTimePoint tp1;
        private LabeledTimePoint tp2;
        public TimeDistance minGuard;
        public TimeDistance maxGuard;
        public TimeDistance contingency;
        public TimeDistance minDist;
        public TimeDistance maxDist;
        public TimeDistance wait;

        public AnalysisResult(LabeledTimePoint tp1, LabeledTimePoint tp2) {
            this.tp1 = tp1;
            this.tp2 = tp2;
        }
    }
}

