/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.actions;

import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TransientTemplateInput;
import de.aristaflow.adept2.util.CheckReport;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.CSTNUEditorActivator;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.EclipseTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class CreateTimeModelAction
implements IEditorActionDelegate {
    private IEditorPart activeEditor;

    public void run(IAction action) {
        if (this.activeEditor instanceof Editor) {
            CheckReport checkReport;
            Template template;
            Editor editor = (Editor)this.activeEditor;
            if (editor.isDirty()) {
                String title = "Unsaved Changes";
                String msg = "The template in the editor contains changes. Do you want to save them before creating the time model?";
                String[] buttonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dlg = new MessageDialog(this.activeEditor.getEditorSite().getShell(), title, null, msg, 3, buttonLabels, 0);
                int returnCode = dlg.open();
                switch (returnCode) {
                    case 0: {
                        this.activeEditor.getSite().getPage().saveEditor((IEditorPart)editor, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            ProcessCheckService processChecks = CSTNUEditorActivator.getModellingClientService().getProcessChecks();
            ProcessTemplateCheckRunner testClientChecks = new ProcessTemplateCheckRunner(new ProcessTemplateCheck[]{processChecks.getConsistencyChecks(), processChecks.getStructureChecks(), processChecks.getBasicModellingChecks()});
            boolean result = testClientChecks.performCheck(template = editor.getTemplate(), new NodeRelations(template), checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost")));
            if (!result) {
                Shell shell = this.activeEditor.getEditorSite().getShell();
                String message = "Template does not fulfil basic checks, aborting!";
                CheckReportDialogue dialog = new CheckReportDialogue(shell, checkReport, message, 1, CheckReport.ResultType.WARNING);
                dialog.open();
                if (checkReport.getCheckResult().compareTo((Enum)CheckReport.ResultType.WARNING) > 0) {
                    return;
                }
            }
            TransientTemplateInput editorInput = new TransientTemplateInput(template);
            EclipseTools.openEditor(CSTNUEditor.ID, (IEditorInput)editorInput);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }
}

