/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.actions;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.EclipseTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editorinputs.TCNEditorInput;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUEditor;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUInstanceEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class ExecuteInstanceAction
implements IEditorActionDelegate {
    private IEditorPart activeEditor;

    public void run(IAction action) {
        if (this.activeEditor instanceof CSTNUEditor) {
            CSTNUEditor editor = (CSTNUEditor)this.activeEditor;
            if (editor.isDirty()) {
                String title = "Unsaved Changes";
                String msg = "The time model in the editor contains changes. Do you want to save them before executing the time model?";
                String[] buttonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dlg = new MessageDialog(this.activeEditor.getEditorSite().getShell(), title, null, msg, 3, buttonLabels, 0);
                int returnCode = dlg.open();
                switch (returnCode) {
                    case 0: {
                        this.activeEditor.getSite().getPage().saveEditor((IEditorPart)editor, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            TCN<LabeledTimePoint, LabeledEdge> tcn = editor.getTCN();
            String name = editor.getPartName();
            final TCNEditorInput editorInput = new TCNEditorInput(name, (TCN<LabeledTimePoint, LabeledEdge>)tcn.clone());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EclipseTools.openEditor(CSTNUInstanceEditor.ID, editorInput);
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }
}

