/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.ContingentConstraintDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabeledEdgeDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.RequirementConstraintDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConstraintPairDialog
extends TitleAreaDialog {
    private SingleArrowCSTNUContentProvider.ConstraintPair edge;
    private AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn;
    private LabeledTimePoint from;
    private LabeledTimePoint to;
    private Text textForward;
    private Text textBackward;
    private LabeledEdge forwardEdge;
    private LabeledEdge backwardEdge;
    private LabelProvider labelProvider;
    private Text edgeText;

    public ConstraintPairDialog(Shell parentShell, LabelProvider labelProvider) {
        super(parentShell);
        this.labelProvider = labelProvider;
    }

    public void create() {
        super.create();
        this.setTitle("Create a new edge pair from " + this.from + " to " + this.to);
        if (this.edge != null) {
            this.forwardEdge = this.edge.getForward();
            this.backwardEdge = this.edge.getBackward();
            this.updateTextFields();
            this.edge = null;
        }
        this.checkValid();
    }

    private void updateTextFields() {
        this.textForward.setText(this.forwardEdge != null ? this.forwardEdge.toString() : "");
        this.textBackward.setText(this.backwardEdge != null ? this.backwardEdge.toString() : "");
        if (this.forwardEdge != null || this.backwardEdge != null) {
            this.edgeText.setText(this.labelProvider.getText((Object)new SingleArrowCSTNUContentProvider.ConstraintPair(this.forwardEdge, this.backwardEdge)));
        } else {
            this.edgeText.setText("");
        }
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledTimePoint from, LabeledTimePoint to) {
        this.tcn = tcn;
        this.from = from;
        this.to = to;
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, SingleArrowCSTNUContentProvider.ConstraintPair constraintPair) {
        this.tcn = tcn;
        this.edge = constraintPair;
        this.from = constraintPair.getSourceNode();
        this.to = constraintPair.getTargetNode();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblForward = new Label(composite, 0);
        lblForward.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblForward.setText("Forward:");
        this.textForward = new Text(composite, 2058);
        GridData gd_textForward = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textForward.heightHint = 60;
        this.textForward.setLayoutData((Object)gd_textForward);
        Button btnEditForward = new Button(composite, 0);
        GridData gd_btnEditForward = new GridData(4, 128, false, false, 1, 1);
        gd_btnEditForward.widthHint = 60;
        gd_btnEditForward.minimumWidth = 60;
        btnEditForward.setLayoutData((Object)gd_btnEditForward);
        btnEditForward.setText("Edit");
        Label lblBackward = new Label(composite, 0);
        lblBackward.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblBackward.setText("Backward:");
        this.textBackward = new Text(composite, 2058);
        GridData gd_textBackward = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textBackward.heightHint = 60;
        this.textBackward.setLayoutData((Object)gd_textBackward);
        final Button btnEditBackward = new Button(composite, 0);
        GridData gd_btnEditBackward = new GridData(4, 128, false, false, 1, 1);
        gd_btnEditBackward.minimumWidth = 60;
        gd_btnEditBackward.widthHint = 60;
        btnEditBackward.setLayoutData((Object)gd_btnEditBackward);
        btnEditBackward.setText("Edit");
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblOverallConstaint = new Label(composite, 64);
        GridData gd_lblOverallConstaint = new GridData(131072, 128, false, false, 1, 1);
        gd_lblOverallConstaint.widthHint = 60;
        lblOverallConstaint.setLayoutData((Object)gd_lblOverallConstaint);
        lblOverallConstaint.setText("Overall Constaint:");
        this.edgeText = new Text(composite, 586);
        GridData gd_text = new GridData(4, 4, true, true, 1, 1);
        gd_text.heightHint = 40;
        gd_text.minimumHeight = 40;
        this.edgeText.setLayoutData((Object)gd_text);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_composite_1 = new GridLayout(1, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        Button btnSetRequirement = new Button(composite_1, 0);
        btnSetRequirement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequirementConstraintDialog dialog = new RequirementConstraintDialog(ConstraintPairDialog.this.getShell());
                if (ConstraintPairDialog.this.forwardEdge != null) {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.forwardEdge, ConstraintPairDialog.this.backwardEdge);
                } else {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.from, ConstraintPairDialog.this.to);
                }
                dialog.create();
                if (dialog.open() == 0) {
                    LabeledEdge[] newEdge = dialog.getLabeledEdges();
                    ConstraintPairDialog.this.forwardEdge = newEdge[1];
                    ConstraintPairDialog.this.backwardEdge = newEdge[0];
                    ConstraintPairDialog.this.updateTextFields();
                    ConstraintPairDialog.this.checkValid();
                    btnEditBackward.setFocus();
                }
            }
        });
        btnSetRequirement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnSetRequirement.setText("Set Requirement");
        Button btnSetContingent = new Button(composite_1, 0);
        btnSetContingent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog dialog = new ContingentConstraintDialog(ConstraintPairDialog.this.getShell());
                if (ConstraintPairDialog.this.forwardEdge != null) {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.forwardEdge, ConstraintPairDialog.this.backwardEdge);
                } else {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.from, ConstraintPairDialog.this.to);
                }
                dialog.create();
                if (dialog.open() == 0) {
                    LabeledEdge[] newEdge = dialog.getLabeledEdges();
                    ConstraintPairDialog.this.forwardEdge = newEdge[1];
                    ConstraintPairDialog.this.backwardEdge = newEdge[0];
                    ConstraintPairDialog.this.updateTextFields();
                    ConstraintPairDialog.this.checkValid();
                    btnEditBackward.setFocus();
                }
            }
        });
        btnSetContingent.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSetContingent.setText("Set Contingent");
        btnEditForward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledEdgeDialog dialog = new LabeledEdgeDialog(ConstraintPairDialog.this.getShell());
                if (ConstraintPairDialog.this.forwardEdge != null) {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.forwardEdge);
                } else {
                    dialog.init((TCN<LabeledTimePoint, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.from, ConstraintPairDialog.this.to);
                }
                dialog.create();
                if (dialog.open() == 0) {
                    LabeledEdge newEdge = dialog.getLabeledEdge();
                    ConstraintPairDialog.this.forwardEdge = newEdge;
                    ConstraintPairDialog.this.updateTextFields();
                    ConstraintPairDialog.this.checkValid();
                    btnEditBackward.setFocus();
                }
            }
        });
        btnEditBackward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledEdgeDialog dialog = new LabeledEdgeDialog(ConstraintPairDialog.this.getShell());
                if (ConstraintPairDialog.this.backwardEdge != null) {
                    dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.backwardEdge);
                } else {
                    dialog.init((TCN<LabeledTimePoint, LabeledEdge>)ConstraintPairDialog.this.tcn, ConstraintPairDialog.this.to, ConstraintPairDialog.this.from);
                }
                dialog.create();
                if (dialog.open() == 0) {
                    LabeledEdge newEdge = dialog.getLabeledEdge();
                    ConstraintPairDialog.this.backwardEdge = newEdge;
                    ConstraintPairDialog.this.updateTextFields();
                    ConstraintPairDialog.this.checkValid();
                    ConstraintPairDialog.this.getButton(0).setFocus();
                }
            }
        });
        btnEditForward.setFocus();
        return dialogArea;
    }

    protected void checkValid() {
        if (this.forwardEdge == null && this.backwardEdge == null) {
            this.setErrorMessage("At least one direction must be set!");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String errorMessage) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(errorMessage == null);
        }
        super.setErrorMessage(errorMessage);
    }

    protected void okPressed() {
        this.edge = this.createConstraintPair();
        super.okPressed();
    }

    public SingleArrowCSTNUContentProvider.ConstraintPair createConstraintPair() {
        SingleArrowCSTNUContentProvider.ConstraintPair pair = new SingleArrowCSTNUContentProvider.ConstraintPair(this.forwardEdge, this.backwardEdge);
        return pair;
    }

    public SingleArrowCSTNUContentProvider.ConstraintPair getConstraintPair() {
        return this.edge;
    }
}

