/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValueWithContingency;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ContingentConstraintDialog
extends TitleAreaDialog {
    private AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn;
    private LabeledEdge backwardEdge;
    private LabeledEdge forwardEdge;
    private LabeledTimePoint from;
    private LabeledTimePoint to;
    private Spinner minSpinner;
    private Spinner maxSpinner;
    private Spinner minGuard;
    private Spinner maxGuard;
    private Spinner spinnerContingency;
    private Label lblContingency;
    private Label lblContingencyIcon;

    public ContingentConstraintDialog(Shell parentShell) {
        super(parentShell);
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledEdge forwardEdge, LabeledEdge backwardEdge) {
        this.init(tcn, (LabeledTimePoint)forwardEdge.getSourceNode(), (LabeledTimePoint)forwardEdge.getTargetNode());
        this.forwardEdge = forwardEdge;
        this.backwardEdge = backwardEdge;
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledTimePoint from, LabeledTimePoint to) {
        this.tcn = tcn;
        this.from = from;
        this.to = to;
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    public void create() {
        super.create();
        this.setTitle("Contingent Constraint from " + this.from + " to " + this.to);
        if (this.backwardEdge != null) {
            this.minSpinner.setSelection((int)((LabeledValueSet)this.backwardEdge.getValue()).getValues()[0].getValue().neg().toSeconds());
            this.minGuard.setSelection((int)((LabeledValueSet)this.backwardEdge.getValue()).getValues()[0].getValue().neg().toSeconds());
        }
        if (this.forwardEdge != null) {
            this.maxSpinner.setSelection((int)((LabeledValueSet)this.forwardEdge.getValue()).getValues()[0].getValue().toSeconds());
            this.maxGuard.setSelection((int)((LabeledValueSet)this.forwardEdge.getValue()).getValues()[0].getValue().toSeconds());
        }
        this.minGuard.setEnabled(false);
        this.minSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.minGuard.setSelection(ContingentConstraintDialog.this.minSpinner.getSelection());
            }
        });
        this.maxGuard.setEnabled(false);
        this.maxSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.maxGuard.setSelection(ContingentConstraintDialog.this.maxSpinner.getSelection());
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(10, false));
        Label lblminvalueMaxvalue = new Label(composite, 0);
        lblminvalueMaxvalue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblminvalueMaxvalue.setText("[[MinValue, MinGuard], [MaxGuard, MaxValue]]:");
        Label label = new Label(composite, 0);
        label.setText("[[");
        this.minSpinner = new Spinner(composite, 2048);
        this.minSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.validate();
            }
        });
        this.minSpinner.setMaximum(1000);
        Label label_3 = new Label(composite, 0);
        label_3.setText(",");
        this.minGuard = new Spinner(composite, 2048);
        this.minGuard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.validate();
            }
        });
        this.minGuard.setMaximum(1000);
        Label label_1 = new Label(composite, 0);
        label_1.setText("],[");
        this.maxGuard = new Spinner(composite, 2048);
        this.maxGuard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.validate();
            }
        });
        this.maxGuard.setMaximum(1000);
        Label label_4 = new Label(composite, 0);
        label_4.setText(",");
        this.maxSpinner = new Spinner(composite, 2048);
        this.maxSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContingentConstraintDialog.this.validate();
            }
        });
        this.maxSpinner.setMaximum(1000);
        Label label_2 = new Label(composite, 0);
        label_2.setText("]]");
        this.lblContingency = new Label(composite, 0);
        this.lblContingency.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblContingency.setText("Contingency:");
        this.lblContingencyIcon = new Label(composite, 0);
        this.lblContingencyIcon.setText("\u2195");
        this.spinnerContingency = new Spinner(composite, 2048);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        return dialogArea;
    }

    protected void validate() {
        if (this.minSpinner.getSelection() > this.maxSpinner.getSelection()) {
            this.setErrorMessage("Min value must be lower than max value!");
            return;
        }
        if (this.minSpinner.getSelection() > this.minGuard.getSelection()) {
            this.setErrorMessage("Min value must be lower than min guard!");
            return;
        }
        if (this.maxSpinner.getSelection() < this.maxGuard.getSelection()) {
            this.setErrorMessage("Max value must be greater than max guard!");
            return;
        }
        this.setErrorMessage(null);
    }

    protected void okPressed() {
        this.createLabeledEdges();
        super.okPressed();
    }

    private void createLabeledEdges() {
        boolean implicit = false;
        boolean control = true;
        DefaultTimeDistance minDist = new DefaultTimeDistance((long)this.minSpinner.getSelection(), 0L, 0L, 0L, 0L);
        DefaultTimeDistance maxGuardDist = new DefaultTimeDistance((long)this.maxGuard.getSelection(), 0L, 0L, 0L, 0L);
        DefaultTimeDistance contingency = new DefaultTimeDistance((long)this.spinnerContingency.getSelection(), 0L, 0L, 0L, 0L);
        DefaultContingentLabeledValueWithContingency minValue = new DefaultContingentLabeledValueWithContingency(this.from.getLabel(), ContingentLabeledValue.ConstraintCase.UPPERCASE, minDist.neg(), this.to, maxGuardDist.neg(), (TimeDistance)contingency);
        DefaultTimeDistance maxDist = new DefaultTimeDistance((long)this.maxSpinner.getSelection(), 0L, 0L, 0L, 0L);
        DefaultTimeDistance minGuardDist = new DefaultTimeDistance((long)this.minGuard.getSelection(), 0L, 0L, 0L, 0L);
        DefaultContingentLabeledValueWithContingency maxValue = new DefaultContingentLabeledValueWithContingency(this.from.getLabel(), ContingentLabeledValue.ConstraintCase.LOWERCASE, (TimeDistance)maxDist, this.to, (TimeDistance)minGuardDist, (TimeDistance)contingency);
        this.backwardEdge = new DefaultLabeledEdge(this.to, this.from, (LabeledValueSet)new DefaultLabeledValueSet(new LabeledValue[]{minValue}), control, implicit, TCNEdge.FlowDirection.BACKWARD);
        this.forwardEdge = new DefaultLabeledEdge(this.from, this.to, (LabeledValueSet)new DefaultLabeledValueSet(new LabeledValue[]{maxValue}), control, implicit, TCNEdge.FlowDirection.FORWARD);
    }

    public LabeledEdge[] getLabeledEdges() {
        return new LabeledEdge[]{this.backwardEdge, this.forwardEdge};
    }
}

