/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.ObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LabelPicker
extends Composite {
    private CheckboxTreeViewer checkboxTreeViewer;
    private List<Label.ChoiceVariable> choiceVariables;

    public LabelPicker(Composite parent, int style) {
        super(parent, style);
        this.createContentArea(this);
    }

    public void setChoiceVariables(List<Label.ChoiceVariable> choiceVariables) {
        this.choiceVariables = choiceVariables;
        this.checkboxTreeViewer.setInput(choiceVariables);
    }

    protected void createContentArea(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.checkboxTreeViewer = new CheckboxTreeViewer(parent, 2048);
        final Tree tree = this.checkboxTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new ChoiceVariableTreeContentProvider());
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    if (event.item.getData() instanceof Label.ChoiceVariable) {
                        event.detail = 0;
                        event.type = 0;
                        event.doit = false;
                        try {
                            tree.setRedraw(false);
                            TreeItem item = (TreeItem)event.item;
                            item.setChecked(!item.getChecked());
                            LabelPicker.this.checkboxTreeViewer.setSubtreeChecked(item.getData(), false);
                        }
                        finally {
                            tree.setRedraw(true);
                        }
                    }
                    if (event.item.getData() instanceof Label.ChoiceVariableBinding) {
                        try {
                            tree.setRedraw(false);
                            TreeItem item = (TreeItem)event.item;
                            Label.ChoiceVariableBinding choiceVariableBinding = (Label.ChoiceVariableBinding)item.getData();
                            Label.ChoiceVariable variable = choiceVariableBinding.getVariable();
                            Label.ChoiceVariableBinding[] choiceVariableBindingArray = variable.getDecisionTimePoint().getChoiceVariableBindings();
                            int n = choiceVariableBindingArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Label.ChoiceVariableBinding binding = choiceVariableBindingArray[n2];
                                if (binding != choiceVariableBinding) {
                                    LabelPicker.this.checkboxTreeViewer.setChecked((Object)binding, false);
                                }
                                ++n2;
                            }
                            LabelPicker.this.checkboxTreeViewer.setGrayed((Object)variable, true);
                        }
                        finally {
                            tree.setRedraw(true);
                        }
                    }
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkboxTreeViewer.getTree().setEnabled(enabled);
    }

    public Label getLabel() {
        Object[] checkedElements = this.checkboxTreeViewer.getCheckedElements();
        ArrayList<ObservationBinding> literals = new ArrayList<ObservationBinding>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (e instanceof ObservationBinding) {
                literals.add((ObservationBinding)e);
            }
            ++n2;
        }
        return new Proposition(literals);
    }

    public void setLabel(Label label) {
        for (Label.ChoiceVariable variable : this.choiceVariables) {
            Label.ChoiceVariableBinding binding = label.getBinding(variable);
            if (binding == null) continue;
            this.checkboxTreeViewer.expandToLevel((Object)variable, 1);
            this.checkboxTreeViewer.setChecked((Object)binding, true);
        }
    }

    private final class ChoiceVariableTreeContentProvider
    implements ITreeContentProvider {
        private ChoiceVariableTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List choiceVariables = (List)inputElement;
            return choiceVariables.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Label.ChoiceVariable) {
                ObservationTimePoint observationTimePoint = ((Label.ChoiceVariable)parentElement).getDecisionTimePoint();
                return observationTimePoint.getChoiceVariableBindings();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Label.ChoiceVariable;
        }
    }
}

