/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabeledValuesControl;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LabeledEdgeDialog
extends TitleAreaDialog {
    private LabeledEdge edge;
    private TCN<LabeledTimePoint, LabeledEdge> tcn;
    private LabeledTimePoint from;
    private LabeledTimePoint to;
    private Button btnControlEdge;
    private Button btnImplicit;
    private Combo comboFlowDirection;
    private LabeledValuesControl edgeControl;

    public LabeledEdgeDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Create a new Labeled Edge from " + this.from + " to " + this.to);
        if (this.edge != null) {
            this.btnImplicit.setSelection(this.edge.isImplicit());
            this.btnControlEdge.setSelection(this.edge.isControlEdge());
            switch (this.edge.getFlowDirection()) {
                case BACKWARD: {
                    this.comboFlowDirection.select(2);
                    break;
                }
                case FORWARD: {
                    this.comboFlowDirection.select(1);
                    break;
                }
                default: {
                    this.comboFlowDirection.select(0);
                }
            }
            this.edgeControl.init(this.tcn, this.from, this.to, ((LabeledValueSet)this.edge.getValue()).getLabeledValues());
            this.edge = null;
        } else {
            this.edgeControl.init(this.tcn, this.from, this.to, new ArrayList<LabeledValue>());
        }
        this.checkValid();
    }

    public void init(TCN<LabeledTimePoint, LabeledEdge> tcn, LabeledTimePoint from, LabeledTimePoint to) {
        this.tcn = tcn;
        this.from = from;
        this.to = to;
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledEdge oldEdge) {
        this.tcn = tcn;
        this.edge = oldEdge;
        this.from = (LabeledTimePoint)oldEdge.getSourceNode();
        this.to = (LabeledTimePoint)oldEdge.getTargetNode();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.createEdgeControl(dialogArea);
        Group grpEdgeProperties = new Group(dialogArea, 0);
        grpEdgeProperties.setLayout((Layout)new GridLayout(3, false));
        grpEdgeProperties.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpEdgeProperties.setText("Edge Properties");
        this.btnControlEdge = new Button((Composite)grpEdgeProperties, 32);
        this.btnControlEdge.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnControlEdge.setText("Control Edge");
        this.btnImplicit = new Button((Composite)grpEdgeProperties, 32);
        this.btnImplicit.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnImplicit.setText("Implicit");
        Composite composite_2 = new Composite((Composite)grpEdgeProperties, 0);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout gl_composite_2 = new GridLayout(2, false);
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        Label lblFlowDirection = new Label(composite_2, 0);
        lblFlowDirection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFlowDirection.setText("Flow Direction");
        this.comboFlowDirection = new Combo(composite_2, 8);
        this.comboFlowDirection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.comboFlowDirection.setItems(new String[]{"Unkown", "Forward", "Backward"});
        this.comboFlowDirection.select(0);
        return dialogArea;
    }

    private void createEdgeControl(Composite dialogArea) {
        this.edgeControl = new LabeledValuesControl(dialogArea, 0);
        this.edgeControl.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.edgeControl.setChangeListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabeledEdgeDialog.this.checkValid();
            }
        });
    }

    protected void checkValid() {
        if (this.edgeControl.getLabeledValues().size() == 0) {
            this.setErrorMessage("At least one value must be added!");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String errorMessage) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(errorMessage == null);
        }
        super.setErrorMessage(errorMessage);
    }

    protected void okPressed() {
        this.edge = this.createLabeledEdge();
        super.okPressed();
    }

    public LabeledEdge createLabeledEdge() {
        TCNEdge.FlowDirection flowDirection;
        DefaultLabeledValueSet labeledValueSet = new DefaultLabeledValueSet(this.edgeControl.getLabeledValues());
        boolean implicit = this.btnImplicit.getSelection();
        boolean control = this.btnControlEdge.getSelection();
        switch (this.comboFlowDirection.getSelectionIndex()) {
            case 1: {
                flowDirection = TCNEdge.FlowDirection.FORWARD;
                break;
            }
            case 2: {
                flowDirection = TCNEdge.FlowDirection.BACKWARD;
                break;
            }
            default: {
                flowDirection = TCNEdge.FlowDirection.UNKOWN;
            }
        }
        return new DefaultLabeledEdge(this.from, this.to, (LabeledValueSet)labeledValueSet, control, implicit, flowDirection);
    }

    public LabeledEdge getLabeledEdge() {
        return this.edge;
    }
}

