/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.STNU;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabelPicker;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class LabeledValueDialog
extends TitleAreaDialog {
    private List<Label.ChoiceVariable> observations;
    private LabeledValue value;
    private LabelPicker labelPicker;
    private Spinner spinnerValue;
    private Combo comboTrigger;
    private Combo comboCase;
    private Spinner spinnerContingentValue;
    private List<LabeledTimePoint> timePoints;
    private Button btnContingent;
    private org.eclipse.swt.widgets.Label lblContingentTimePoint;
    private org.eclipse.swt.widgets.Label lblCase;
    private org.eclipse.swt.widgets.Label lblcontingentValue;
    private org.eclipse.swt.widgets.Label lblSecondsContingent;
    private TCN<LabeledTimePoint, LabeledEdge> tcn;
    private Label label;
    private org.eclipse.swt.widgets.Label lblContingency;
    private Spinner spinnerContingency;

    public LabeledValueDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create a Labeled Edge");
    }

    public void create() {
        super.create();
        this.setTitle("Create a new Labeled Value");
        if (this.observations != null) {
            this.labelPicker.setChoiceVariables(this.observations);
            this.labelPicker.setEnabled(true);
        } else {
            this.labelPicker.setEnabled(false);
        }
        String[] nodes = new String[this.timePoints.size()];
        int i = 0;
        while (i < this.timePoints.size()) {
            nodes[i] = this.timePoints.get(i).toString();
            ++i;
        }
        this.comboTrigger.setItems(nodes);
        this.labelPicker.setLabel(this.label);
        if (this.value != null) {
            this.spinnerValue.setSelection((int)this.value.getValue().toSeconds());
            this.btnContingent.setEnabled(this.tcn instanceof STNU);
            if (this.value instanceof ContingentLabeledValue) {
                ContingentLabeledValue cValue = (ContingentLabeledValue)this.value;
                this.btnContingent.setSelection(true);
                this.comboCase.select(cValue.getCase().equals((Object)ContingentLabeledValue.ConstraintCase.UPPERCASE) ? 0 : 1);
                this.comboTrigger.select(this.timePoints.indexOf(cValue.getTrigger()));
                this.spinnerContingentValue.setSelection((int)cValue.getContingentValue().toSeconds());
                this.setContingent(true);
            } else {
                this.setContingent(false);
            }
            this.value = null;
        }
        ((GridData)this.lblContingency.getLayoutData()).exclude = true;
        this.lblContingency.setVisible(false);
        ((GridData)this.spinnerContingency.getLayoutData()).exclude = true;
        this.spinnerContingency.setVisible(false);
    }

    public void init(TCN<LabeledTimePoint, LabeledEdge> tcn, Label label) {
        this.tcn = tcn;
        this.label = label;
        this.timePoints = new ArrayList<LabeledTimePoint>(tcn.getTimePoints());
        if (tcn instanceof CSTN) {
            CSTN cstn = (CSTN)tcn;
            this.observations = cstn.getObservations();
        } else {
            this.observations = null;
        }
    }

    public void init(TCN<LabeledTimePoint, LabeledEdge> tcn, LabeledValue value) {
        this.init(tcn, value.getLabel());
        this.value = value;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        org.eclipse.swt.widgets.Label lblValue = new org.eclipse.swt.widgets.Label(composite, 0);
        lblValue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblValue.setText("Value");
        this.spinnerValue = new Spinner(composite, 2048);
        this.spinnerValue.setMaximum(99999);
        this.spinnerValue.setMinimum(-99999);
        this.spinnerValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        SelectionAdapter validListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledValueDialog.this.checkValid();
            }
        };
        this.spinnerValue.addSelectionListener((SelectionListener)validListener);
        org.eclipse.swt.widgets.Label lblSeconds = new org.eclipse.swt.widgets.Label(composite, 0);
        lblSeconds.setText("seconds");
        this.btnContingent = new Button(composite, 32);
        this.btnContingent.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnContingent.setText("Contingent");
        new org.eclipse.swt.widgets.Label(composite, 0);
        this.btnContingent.addSelectionListener((SelectionListener)validListener);
        Group grpContingent = new Group(composite, 0);
        grpContingent.setLayout((Layout)new GridLayout(3, false));
        grpContingent.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        grpContingent.setText("Contingent");
        this.lblContingentTimePoint = new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.lblContingentTimePoint.setEnabled(false);
        this.lblContingentTimePoint.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblContingentTimePoint.setText("Contingent Time Point");
        this.comboTrigger = new Combo((Composite)grpContingent, 8);
        this.comboTrigger.addSelectionListener((SelectionListener)validListener);
        this.comboTrigger.setEnabled(false);
        this.comboTrigger.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblCase = new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.lblCase.setEnabled(false);
        this.lblCase.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblCase.setText("Case");
        this.comboCase = new Combo((Composite)grpContingent, 8);
        this.comboCase.addSelectionListener((SelectionListener)validListener);
        this.comboCase.setItems(new String[]{"Upper Case", "Lower Case"});
        this.comboCase.setEnabled(false);
        this.comboCase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblcontingentValue = new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.lblcontingentValue.setEnabled(false);
        this.lblcontingentValue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblcontingentValue.setText("Value");
        this.spinnerContingentValue = new Spinner((Composite)grpContingent, 2048);
        this.spinnerContingentValue.setMaximum(99999);
        this.spinnerContingentValue.setMinimum(-99999);
        this.spinnerContingentValue.addSelectionListener((SelectionListener)validListener);
        this.spinnerContingentValue.setEnabled(false);
        this.lblSecondsContingent = new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.lblSecondsContingent.setEnabled(false);
        this.lblSecondsContingent.setText("seconds");
        this.lblContingency = new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.lblContingency.setEnabled(false);
        this.lblContingency.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblContingency.setText("Contingency");
        this.spinnerContingency = new Spinner((Composite)grpContingent, 2048);
        this.spinnerContingency.setEnabled(false);
        this.spinnerContingency.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new org.eclipse.swt.widgets.Label((Composite)grpContingent, 0);
        this.btnContingent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledValueDialog.this.setContingent(LabeledValueDialog.this.btnContingent.getSelection());
            }
        });
        org.eclipse.swt.widgets.Label lblLabel = new org.eclipse.swt.widgets.Label(composite, 0);
        lblLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblLabel.setText("Label");
        this.labelPicker = new LabelPicker(composite, 0);
        this.labelPicker.setEnabled(false);
        this.labelPicker.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        return dialogArea;
    }

    private void setContingent(boolean enabled) {
        this.lblContingentTimePoint.setEnabled(enabled);
        this.comboTrigger.setEnabled(enabled);
        this.comboCase.setEnabled(enabled);
        this.lblCase.setEnabled(enabled);
        this.lblContingency.setEnabled(enabled);
        this.spinnerContingency.setEnabled(enabled);
        this.lblcontingentValue.setEnabled(enabled);
        this.spinnerContingentValue.setEnabled(enabled);
        this.lblSecondsContingent.setEnabled(enabled);
    }

    protected void checkValid() {
        if (this.btnContingent.getSelection()) {
            if (this.comboCase.getSelectionIndex() < 0) {
                this.setErrorMessage("A Constraint Case must be selected!");
                return;
            }
            if (this.comboTrigger.getSelectionIndex() < 0) {
                this.setErrorMessage("A Contingent Node must be selected!");
                return;
            }
            if (this.spinnerValue.getSelection() < this.spinnerContingentValue.getSelection()) {
                this.setErrorMessage("Contingent Value must be less than normal value!");
                return;
            }
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String errorMessage) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(errorMessage == null);
        }
        super.setErrorMessage(errorMessage);
    }

    protected void okPressed() {
        this.value = this.createLabeledValue();
        super.okPressed();
    }

    public LabeledValue createLabeledValue() {
        DefaultLabeledValue labeledValue;
        Label label = this.labelPicker.getLabel();
        DefaultTimeDistance value = new DefaultTimeDistance((long)this.spinnerValue.getSelection(), 0L, 0L, 0L, 0L);
        if (!this.btnContingent.getSelection()) {
            labeledValue = new DefaultLabeledValue(label, (TimeDistance)value);
        } else {
            ContingentLabeledValue.ConstraintCase constraintCase = this.comboCase.getSelectionIndex() == 1 ? ContingentLabeledValue.ConstraintCase.LOWERCASE : ContingentLabeledValue.ConstraintCase.UPPERCASE;
            LabeledTimePoint trigger = this.timePoints.get(this.comboTrigger.getSelectionIndex());
            DefaultTimeDistance contingentValue = new DefaultTimeDistance((long)this.spinnerContingentValue.getSelection(), 0L, 0L, 0L, 0L);
            labeledValue = new DefaultContingentLabeledValue(label, constraintCase, (TimeDistance)value, trigger, (TimeDistance)contingentValue);
        }
        return labeledValue;
    }

    public LabeledValue getLabeledValue() {
        return this.value;
    }
}

