/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabeledValueDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class LabeledValuesControl
extends Composite {
    private ListViewer listViewer;
    private List<LabeledValue> labeledValues = new ArrayList<LabeledValue>();
    private TCN<LabeledTimePoint, LabeledEdge> tcn;
    private LabeledTimePoint from;
    private LabeledTimePoint to;
    private ModifyListener listener;
    private Composite subComposite;

    public LabeledValuesControl(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createContent(this, (style & 8) != 0);
    }

    public void init(TCN<LabeledTimePoint, LabeledEdge> tcn, LabeledTimePoint from, LabeledTimePoint to, Collection<LabeledValue> labeledValues) {
        this.tcn = tcn;
        this.from = from;
        this.to = to;
        this.labeledValues = new ArrayList<LabeledValue>(labeledValues);
        this.listViewer.setInput(this.labeledValues);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.subComposite != null) {
            this.subComposite.setBackground(color);
        }
    }

    private void createContent(Composite composite, final boolean readOnly) {
        this.listViewer = new ListViewer(composite, 2560);
        if (!readOnly) {
            this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        LabeledValue value = (LabeledValue)selection.getFirstElement();
                        LabeledValuesControl.this.editLabeledValue(value);
                    }
                }
            });
        }
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (!readOnly) {
            this.subComposite = new Composite(composite, 0);
            GridLayout gl_composite_1 = new GridLayout(1, false);
            gl_composite_1.marginWidth = 0;
            gl_composite_1.marginHeight = 0;
            this.subComposite.setLayout((Layout)gl_composite_1);
            this.subComposite.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
            Button btnAdd = new Button(this.subComposite, 0);
            btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LabeledValuesControl.this.addLabeledValue();
                }
            });
            btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            btnAdd.setText("Add Value");
            final Button btnEdit = new Button(this.subComposite, 0);
            btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)LabeledValuesControl.this.listViewer.getSelection();
                    LabeledValuesControl.this.editLabeledValue((LabeledValue)selection.getFirstElement());
                }
            });
            btnEdit.setEnabled(false);
            btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            btnEdit.setText("Edit Value");
            final Button btnRemove = new Button(this.subComposite, 0);
            btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LabeledValuesControl.this.removeLabeledValue();
                }
            });
            btnRemove.setEnabled(false);
            btnRemove.setText("Remove Value");
            this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    btnRemove.setEnabled(!readOnly && !event.getSelection().isEmpty());
                    btnEdit.setEnabled(!readOnly && !event.getSelection().isEmpty());
                }
            });
            btnAdd.setEnabled(!readOnly);
        }
    }

    protected void editLabeledValue(LabeledValue value) {
        LabeledValueDialog dialog = new LabeledValueDialog(this.getShell());
        dialog.init(this.tcn, value);
        if (dialog.open() == 0) {
            LabeledValue labeledValue = dialog.getLabeledValue();
            this.labeledValues.remove(value);
            this.labeledValues.add(labeledValue);
            this.listViewer.refresh(false);
        }
        this.notifyChangeListeners();
    }

    protected void removeLabeledValue() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            LabeledValue value = (LabeledValue)o;
            this.labeledValues.remove(value);
            this.listViewer.refresh(false);
            ++n2;
        }
        this.notifyChangeListeners();
    }

    private void notifyChangeListeners() {
        if (this.listener != null) {
            Event e = new Event();
            e.widget = this;
            e.display = this.getDisplay();
            this.listener.modifyText(new ModifyEvent(e));
        }
    }

    public void setChangeListener(ModifyListener listener) {
        this.listener = listener;
    }

    protected void addLabeledValue() {
        LabeledValueDialog dialog = new LabeledValueDialog(this.getShell());
        dialog.init(this.tcn, this.from.getLabel().merge(this.to.getLabel()));
        if (dialog.open() == 0) {
            LabeledValue labeledValue = dialog.getLabeledValue();
            this.labeledValues.add(labeledValue);
            this.listViewer.refresh(false);
        }
        this.notifyChangeListeners();
    }

    public List<LabeledValue> getLabeledValues() {
        return this.labeledValues;
    }

    public LabeledEdge getLabeledEdge() {
        return new DefaultLabeledEdge(this.from, this.to, (LabeledValueSet)new DefaultLabeledValueSet(this.getLabeledValues()));
    }
}

