/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class RequirementConstraintDialog
extends TitleAreaDialog {
    private AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn;
    private LabeledTimePoint from;
    private LabeledTimePoint to;
    private LabeledEdge forwardEdge;
    private LabeledEdge backwardEdge;
    private Spinner maxSpinner;
    private Spinner minSpinner;

    public RequirementConstraintDialog(Shell parentShell) {
        super(parentShell);
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledEdge forwardEdge, LabeledEdge backwardEdge) {
        this.tcn = tcn;
        this.forwardEdge = forwardEdge;
        this.backwardEdge = backwardEdge;
        this.from = (LabeledTimePoint)forwardEdge.getSourceNode();
        this.to = (LabeledTimePoint)forwardEdge.getTargetNode();
    }

    public void init(AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge> tcn, LabeledTimePoint from, LabeledTimePoint to) {
        this.tcn = tcn;
        this.from = from;
        this.to = to;
    }

    public void create() {
        super.create();
        this.setTitle("Requirement Constraint from " + this.from + " to " + this.to);
        if (this.backwardEdge != null) {
            this.minSpinner.setSelection((int)((LabeledValueSet)this.backwardEdge.getValue()).getValues()[0].getValue().neg().toSeconds());
        }
        if (this.forwardEdge != null) {
            this.maxSpinner.setSelection((int)((LabeledValueSet)this.forwardEdge.getValue()).getValues()[0].getValue().toSeconds());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(6, false));
        Label lblminvalueMaxvalue = new Label(composite, 0);
        lblminvalueMaxvalue.setText("[MinValue, MaxValue]:");
        Label label = new Label(composite, 0);
        label.setText("[");
        this.minSpinner = new Spinner(composite, 2048);
        this.minSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequirementConstraintDialog.this.validate();
            }
        });
        this.minSpinner.setMaximum(1000);
        this.minSpinner.setMinimum(-1000);
        Label label_1 = new Label(composite, 0);
        label_1.setText(",");
        this.maxSpinner = new Spinner(composite, 2048);
        this.maxSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequirementConstraintDialog.this.validate();
            }
        });
        this.maxSpinner.setMaximum(1000);
        this.maxSpinner.setMinimum(-1000);
        Label label_2 = new Label(composite, 0);
        label_2.setText("]");
        return dialogArea;
    }

    protected void validate() {
        if (this.minSpinner.getSelection() > this.maxSpinner.getSelection()) {
            this.setErrorMessage("Min value must be lower than max value!");
        } else {
            this.setErrorMessage(null);
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    protected void okPressed() {
        this.createLabeledEdges();
        super.okPressed();
    }

    private void createLabeledEdges() {
        boolean implicit = false;
        boolean control = true;
        DefaultTimeDistance minDist = new DefaultTimeDistance((long)this.minSpinner.getSelection(), 0L, 0L, 0L, 0L);
        DefaultLabeledValue minValue = new DefaultLabeledValue(this.from.getLabel(), minDist.neg());
        DefaultTimeDistance maxDist = new DefaultTimeDistance((long)this.maxSpinner.getSelection(), 0L, 0L, 0L, 0L);
        DefaultLabeledValue maxValue = new DefaultLabeledValue(this.from.getLabel(), (TimeDistance)maxDist);
        this.backwardEdge = new DefaultLabeledEdge(this.to, this.from, (LabeledValueSet)new DefaultLabeledValueSet(new LabeledValue[]{minValue}), control, implicit, TCNEdge.FlowDirection.BACKWARD);
        this.forwardEdge = new DefaultLabeledEdge(this.from, this.to, (LabeledValueSet)new DefaultLabeledValueSet(new LabeledValue[]{maxValue}), control, implicit, TCNEdge.FlowDirection.FORWARD);
    }

    public LabeledEdge[] getLabeledEdges() {
        return new LabeledEdge[]{this.backwardEdge, this.forwardEdge};
    }
}

